﻿using ASHermed.SinoInterface.Api.ContractModel.Framework.Login;
using ASHermed.SinoInterface.ContractModel;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace ASHermed.SinoInterface.IFramework.SingleSignOn
{
    /// <summary>
    /// 登录服务
    /// 创建人：杨江军
    /// 创建时间：2020/4/9 14:33:15
    /// </summary>
    public interface ILoginService
    {
        /// <summary>
        /// 发送短信验证码
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        Task<BaseResponse> SendSMSVerifyCode(SendSMSVerifyCodeParam param);

        /// <summary>
        /// 通过手机号码和验证码进行单点登录
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        Task<BaseResponse<SingleSignOnModel>> SingleSignOnByPhones(SingleSignOnByPhonesParam param);

        /// <summary>
        /// 通过登录名和密码进行单点登录
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        Task<BaseResponse<SingleSignOnModel>> SingleSignOnByLoginId(SingleSignOnByLoginIdParam param);

        /// <summary>
        /// 刷新Token
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        Task<BaseResponse<RefreshTokenModel>> RefreshToken(RefreshTokenParam param);

        /// <summary>
        /// 退出登录
        /// </summary>
        /// <param name="param"></param>
        /// <returns></returns>
        Task<BaseResponse> SignOut(SignOutParam param);
    }
}
