﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class VaccineAptModel
    {


    }

    public class VaccineSchedulingReq
    {
        public int HosId { set; get; }
        public string PatBirthday { set; get; }
        public string StartTime { set; get; }
        public string EndTime { set; get; }
    }

    public class VaccineAptInfo : IDataModel
    {
        public int Id { set; get; }
        public int PatId { set; get; }
        public string PatName { set; get; }
        public string PatBirthday { set; get; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string PatPhone { set; get; }
        public int PatType { set; get; }
        public string PatDesc { set; get; }
        public string VaccineName { set; get; }
        public string VaccineBrand { set; get; }
        public int VaccineOrigin { set; get; }
        public string VaccineOriginName { set; get; }
        public string HosName { set; get; }
        public int HosId { set; get; }
        /// <summary>
        /// 是否是临时就诊人
        /// </summary>
        public bool Temporary { set; get; }
    }

    public class VaccineApt
    {
        /// <summary>
        /// 排队ID  (out_vaccine_appt主键)
        /// </summary>
        public int VaccId { set; get; }
        public int PatId { set; get; }
        /// <summary>
        /// 预约时间(yyyy-MM-dd)
        /// </summary>
        public string AptDayTime { set; get; }
        /// <summary>
        /// 预约时间(HH:mm)
        /// </summary>
        public string AptHourTime { set; get; }
        /// <summary>
        /// his科室
        /// </summary>
        public int HisDeptId { set; get; }
        /// <summary>
        /// his服务
        /// </summary>
        public int HisServId { set; get; }
        /// <summary>
        /// his医生
        /// </summary>
        public int CareProvId { set; get; }
        /// <summary>
        /// 本地诊所ID
        /// </summary>
        public int HosId { set; get; }
        /// <summary>
        /// 是否需要前台询问 患者是否有禁忌症
        /// </summary>
        public bool IsNeekAsk { set; get; }
        /// <summary>
        /// 语言1中2英
        /// </summary>
        public int Language { set; get; }
        /// <summary>
        /// 0为个人预约 1为企业预约
        /// </summary>
        public int? Type { set; get; }
        /// <summary>
        /// 疫苗产地  1=国产/2=进口/3均可
        /// </summary>
        public int? Origin { set; get; }
        /// <summary>
        /// 渠道1APP、2小程序、3微信、4官网 、5APP安卓、6APPIOS
        /// </summary>
        public int? Channel { set; get; }
    }

    public class VaccGroupCount
    {
        /// <summary>
        /// 是否是企业
        /// </summary>
        public bool IsCompanyPhone { set; get; } = false;
        /// <summary>
        /// 剩余次数
        /// </summary>
        public int SurplusCount { set; get; }
        //public int HosId { set; get; }
        //public string HosName { set; get; }
        //public string VaccineBrand { set; get; }
        //public int PatId { set; get; }
        //public string PatName { set; get; }
        //public string PatBirthday { set; get; }

    }

    public class VaccGroupInfo
    {

        public int HosId { set; get; }
        public string HosName { set; get; }
        public string VaccineBrand { set; get; }
        public int PatId { set; get; }
        public string PatName { set; get; }
        public string PatPhone { set; get; }
        public string PatBirthday { set; get; }
        /// <summary>
        /// 是否是临时就诊人
        /// </summary>
        public bool Temporary { set; get; }
        public string VaccineName { set; get; }
        public int Origin { set; get; }

        /// <summary>
        /// 可预约时间-开始
        /// </summary>
        public DateTime AptTimeBegin { get; set; }

        /// <summary>
        /// 可预约时间-结束
        /// </summary>
        public DateTime AptTimeEnd { get; set; }
    }
}
