﻿using System.Collections.Generic;
using System.Xml.Serialization;

namespace ASHermed.SinoInterface.Api.ContractModel.TCTrans.Output
{
    /// <summary>
    /// 患者查询响应参数
    /// 1：根据mrn查询
    /// 2：根据PID查询
    /// 3：根据身份证号查询
    /// 4：根据姓名、出生日期、性别查询
    /// </summary>
    [XmlRoot("GetPatientByMRNResult")]
    public class GetPatientOutput
    {
        /// <summary>
        /// ctor
        /// </summary>
        public GetPatientOutput()
        {
            Persons = new List<PAPerson>();
        }

        /// <summary>
        /// 患者信息
        /// </summary>
        [XmlArray("persons")]
        [XmlArrayItem("PAPerson")]
        public List<PAPerson> Persons { get; set; }
    }
}