﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Shared.Log
{
    /// <summary>
	/// 分页查询接口日志数据[参数]
	/// 创建人：杨江军
	/// 创建时间：2020/7/13/星期一 15:58:54
	/// </summary>
	public class GetApiLogsPageListParam
    {
        /// <summary>
        /// 接口名称[不支持模糊查询]
        /// </summary>
        public string APIName { get; set; }

        /// <summary>
        /// 请求时间[开始]
        /// </summary>
        public DateTime RequestTimeBegin { get; set; }

        /// <summary>
        /// 请求时间[结束]
        /// </summary>
        public DateTime RequestTimeEnd { get; set; }

        /// <summary>
        /// 请求耗时（毫秒）[开始][无数据传入-1]
        /// </summary>
        public int TimeCostBegin { get; set; }

        /// <summary>
        /// 请求耗时（毫秒）[结束][无数据传入-1]
        /// </summary>
        public int TimeCostEnd { get; set; }

        /// <summary>
        /// 接口请求参数[模糊查询]
        /// </summary>
        public string RequestBody { get; set; }

        /// <summary>
        /// 接口返回结果[模糊查询]
        /// </summary>
        public string ResponseBody { get; set; }

        /// <summary>
        /// 是否为报错日志
        /// </summary>
        public bool? IsError { get; set; }

        /// <summary>
        /// 页数
        /// </summary>
        [Required(ErrorMessage = "[页数]不能为空")]
        [Range(0, int.MaxValue, ErrorMessage = "[页数]输入错误！")]
        public int PageIndex { get; set; }

        /// <summary>
        /// 每页数据的数量
        /// </summary>
        [Required(ErrorMessage = "[每页数据的数量]不能为空")]
        [Range(1, int.MaxValue, ErrorMessage = "[每页数据的数量]输入错误！")]
        public int PageSize { get; set; } = 10;
    }
}
