﻿using ASHermed.SinoInterface.Enum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Shared
{
    /// <summary>
	/// 基础客户端请求接口参数
	/// 创建人：杨江军
	/// 创建时间：2020/4/8 16:32:52
	/// </summary>
	public class BaseClientParam
    {
        /// <summary>
        /// 客户端ID（每个设备的唯一ID）
        /// </summary>
        [Required(ErrorMessage = "[客户端ID]不能为空")]
        public string ClientId { get; set; }

        /// <summary>
        /// 客户端类型
        /// </summary>
        [Required(ErrorMessage = "[客户端类型]不能为空")]
        [Range(1, 3, ErrorMessage = "[客户端类型]错误，只能选择枚举范围内大于0的值！")]
        public ClientType ClientType { get; set; }

        /// <summary>
        /// 系统ID（不需要传入）
        /// </summary>
        //[Required(ErrorMessage = "[系统ID]不能为空")]
        public long SystemId { get; set; }
    }
}
