﻿using System;
using System.Collections.Generic;
using System.Text;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class YouZanModel
    {

    }

    /// <summary>
    /// 有赞配置
    /// </summary>
    public static class YouZanConfig
    {
        /// <summary>
        /// 有赞云颁发给开发者的应用ID
        /// </summary>
        public static string ClientId = "c82e891dd59d8f18db";

        /// <summary>
        /// 有赞云颁发给开发者的应用secret
        /// </summary>
        public static string ClientSecret = "38a3324976be9314502cb95717c0f269";

        /// <summary>
        /// 授与方式（固定为 “silent”）
        /// </summary>
        public static string AuthorizeType = "silent";

        /// <summary>
        /// 授权店铺id（即kdt_id），API接口对接传店铺id，支付商户对接传mchId
        /// </summary>
        public static string GrantId = "42537751";

        /// <summary>
        /// “健康俱乐部”权益卡别名
        /// 正式：Y270djc2hy9pvr
        /// 测试：Y2g1kxw8r885ef
        /// </summary>
        public static string HealthClubCardAlias = "Y270djc2hy9pvr";

        /// <summary>
        /// “健康俱乐部”权益卡唯一id
        /// 正式：112481600
        /// 测试：112477612
        /// </summary>
        public static int HealthClubCardId = 112481600;

        /// <summary>
        /// “健康俱乐部”商品别名
        /// 正式：362yqgfirbkzbx3
        /// 测试：2oswpuar6kw2foh
        /// </summary>
        public static string HealthClubGoodsAlias = "362yqgfirbkzbx3";
    }

    public class YouZanTokenRequst
    {
        /// <summary>
        /// 有赞云颁发给开发者的应用ID
        /// </summary>
        public string client_id { get; set; } = YouZanConfig.ClientId;
        /// <summary>
        /// 有赞云颁发给开发者的应用secret
        /// </summary>
        public string client_secret { get; set; } = YouZanConfig.ClientSecret;
        /// <summary>
        /// 授与方式（固定为 “silent”）
        /// </summary>
        public string authorize_type { get; set; } = YouZanConfig.AuthorizeType;
        /// <summary>
        /// 授权店铺id（即kdt_id），API接口对接传店铺id，支付商户对接传mchId
        /// </summary>
        public string grant_id { get; set; } = YouZanConfig.GrantId;
        /// <summary>
        /// 是否刷新，该参数默认为“false”
        /// </summary>
        public bool refresh { get; set; } = true;
    }
    public class YouZanTokenResponse
    {
        public bool success { get; set; }
        public int code { get; set; }
        public YouZanTokenData data { get; set; }
        public string message { get; set; }
    }

    public class YouZanTokenData
    {
        /// <summary>
        /// 用于调用 API 的 access_token，有效7天
        /// </summary>
        public string access_token { get; set; }
        /// <summary>
        /// access_token 的过期时间，时间戳（单位：毫秒；过期时间：7天）
        /// </summary>
        public string expires { get; set; }
        /// <summary>
        /// access_token 最终的访问范围
        /// </summary>
        public string scope { get; set; }
        /// <summary>
        /// 授权主体id，即店铺id
        /// </summary>
        public string authority_id { get; set; }
        /// <summary>
        /// 用于刷新access_token的刷新令牌（过期时间：28天）
        /// </summary>
        public string refresh_token { get; set; }
    }

    public class UserQuery
    {
        /// <summary>
        /// 有赞用户id，用户在有赞的唯一id。推荐使用；和mobile、weixin_union_id、weixin_open_id至少传一个
        /// </summary>
        public string yz_open_id { get; set; }
    }

    public class YouZanResponse<T>
    {
        public bool success { get; set; }
        public int code { get; set; }
        public T data { get; set; }
        public string message { get; set; }
    }

    public class YouZanUser
    {
        /// <summary>
        /// 根据查询请求，返回指定的平台帐号信息
        /// </summary>
        public List<YZUser> user_list { get; set; }
        /// <summary>
        /// 最新的用户信息
        /// </summary>
        public LatestInfo latest_info { get; set; }
    }

    public class YZUser
    {
        /// <summary>
        /// 微信公众号、小程序粉丝特有
        /// </summary>
        public Wechat wechat_info { get; set; }
        /// <summary>
        /// 基本信息，所有平台通用
        /// </summary>
        public Primitive primitive_info { get; set; }
        /// <summary>
        /// mobile帐号信息
        /// </summary>
        public Mobile mobile_info { get; set; }
        /// <summary>
        /// 平台帐号信息，包括微信、快手等三方平台
        /// </summary>
        public Platform platform_info { get; set; }
    }

    public class Wechat
    {

        /// <summary>
        /// 1-公众号、2-小程序
        /// </summary>
        public int wechat_type { get; set; }
        /// <summary>
        /// 公众号粉丝特有，0表示取消关注，1表示关注，2表示是静默授权登录产生的粉丝，没有关注也没有取关
        /// </summary>
        public int is_fans { get; set; }
        /// <summary>
        /// 关注时间，公众号粉丝特有，Unix时间戳，单位：秒
        /// </summary>
        public long follow_time { get; set; }
        /// <summary>
        /// 粉丝最后对话时间,公众号粉丝特有，Unix时间戳，单位：秒
        /// </summary>
        public int last_talk_time { get; set; }
        /// <summary>
        /// 微信全局标识
        /// </summary>
        public string union_id { get; set; }
        /// <summary>
        /// 取关时间，公众号粉丝特有，Unix时间戳，单位：秒
        /// </summary>
        public long unfollow_time { get; set; }

    }

    public class Primitive
    {
        /// <summary>
        /// 性别,0-未知，1-男，2-女
        /// </summary>
        public int gender { get; set; }
        /// <summary>
        /// 省份
        /// </summary>
        public string province { get; set; }
        /// <summary>
        /// 城市
        /// </summary>
        public string city { get; set; }
        /// <summary>
        /// 用户创建时间，时间格式：yyyy-MM-dd-HH-mm-ss；和platform_type类型对应  2020-11-11 20:11:11
        /// </summary>
        public DateTime created_time { get; set; }
        /// <summary>
        /// 用户最后更新时间，时间格式：yyyy-MM-dd-HH-mm-ss；和platform_type类型对应
        /// </summary>
        public DateTime updated_time { get; set; }
        /// <summary>
        /// 昵称
        /// </summary>
        public string nick_name { get; set; }
        /// <summary>
        /// 国家
        /// </summary>
        public string country { get; set; }
        /// <summary>
        /// 平台类型，0-手机帐号；1-微信H5帐号；其他表示微信小程序
        /// </summary>
        public int platform_type { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string avatar { get; set; }
        /// <summary>
        /// 有赞用户id，用户在有赞的唯一id
        /// </summary>
        public string yz_open_id { get; set; }

    }

    public class Mobile
    {
        /// <summary>
        /// 用户手机号
        /// </summary>
        public string mobile { get; set; }
    }

    public class Platform
    {
        /// <summary>
        /// 平台帐号唯一标识，如QQ、微博、三方APP标识
        /// </summary>
        public string weixin_open_id { get; set; }
    }


    public class LatestInfo
    {
        /// <summary>
        /// 头像，和B端店铺后台客户详情头像一致，推荐使用
        /// </summary>
        public string avatar { get; set; }
        /// <summary>
        /// 昵称和B端店铺后台客户详情昵称一致，推荐使用
        /// </summary>
        public string nick_name { get; set; }
    }

    public class UpdateUserModel
    {
        /// <summary>
        /// 用户帐号信息
        /// </summary>
        public AccountInfo account { get; set; }
        /// <summary>
        /// 会员创建时间（时间格式:yyyy-MM-dd HH:mm:ss）当且仅当该用户是会员的情况下，更新会员创建时间有效
        /// </summary>
        public string member_created_at { get; set; }
        /// <summary>
        /// scrm渠道类型（2:伯俊）
        /// </summary>
        public int scrm_channel_type { get; set; }
        /// <summary>
        /// 是否走扩展点（不传默认为true）， true-走扩展点 false-不走扩展点 (其中扩展点为：第三方修改客户信息扩展点)
        /// </summary>
        public bool is_do_ext_point { get; set; }
        /// <summary>
        /// 更新客户所需信息
        /// </summary>
        public UpdateInfo customer_update { get; set; }
        /// <summary>
        /// 用户创建时间（时间格式:yyyy-MM-dd HH:mm:ss）
        /// </summary>
        public string create_date { get; set; }
    }

    public class UpdateInfo
    {
        /// <summary>
        /// 联系地址结构体
        /// </summary>
        public AddressInfo contact_address { get; set; }
        /// <summary>
        /// 生日(时间格式:yyyy-MM-dd HH:mm:ss)
        /// </summary>
        public string birthday { get; set; }
        /// <summary>
        /// 性别，0：未知；1：男；2：女
        /// </summary>
        public int gender { get; set; }
        /// <summary>
        /// 姓名
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 微信号
        /// </summary>
        public string wei_xin { get; set; }
        /// <summary>
        /// 归属门店
        /// </summary>
        public int ascription_kdt_id { get; set; }
    }
    public class AddressInfo
    {
        /// <summary>
        /// 详细地址:辽宁省沈阳市
        /// </summary>
        public string address { get; set; }
        /// <summary>
        /// 地区编码:2210
        /// </summary>
        public int area_code { get; set; }
    }
    public class AccountInfo
    {
        /// <summary>
        /// 帐号ID
        /// </summary>
        public string account_id { get; set; }
        /// <summary>
        /// 帐号类型。目前支持以下选项（只支持传一种）： FansID：自有粉丝ID， Mobile：手机号， YouZanAccount：有赞账号，YzOpenId：有赞OpenId
        /// </summary>
        public string account_type { get; set; }
    }

    public class CustomerGetRequest
    {
        /// <summary>
        /// 需要获得的用户属性，使用","隔开，包含以下user_base（基础信息）,tags（标签）,benefit_cards（权益卡）,benefit_level（等级）,benefit_rights（权益）,credit（积分）,behavior（交易行为）,giftcard（礼品卡）,prepaid（储值）,coupon（优惠券）,level（会员等级信息）
        /// </summary>
        public string fields { get; set; }
        /// <summary>
        /// 有赞用户id，用户在有赞的唯一id。推荐使用
        /// </summary>
        public string yz_open_id { get; set; }
        /// <summary>
        /// 是否走扩展点，不传参默认走扩展点（true-走第三方调用 false-不走第三方调用）当值为true的时候触发调用查询客户详细信息扩展点
        /// </summary>
        public bool is_do_ext_point { get; set; }
    }

    public class CustomerInfo
    {
        /// <summary>
        /// 客户权益
        /// </summary>
        public List<CustomerRight> rights { get; set; }
        /// <summary>
        /// 最后购买时间，Unix时间戳，单位：秒1594296126604
        /// </summary>
        public long last_trade_at { get; set; }
        /// <summary>
        /// 礼品卡余额，单位：分
        /// </summary>
        public long giftcard_balance { get; set; }
        /// <summary>
        /// 客户联系手机号
        /// </summary>
        public string mobile { get; set; }
        /// <summary>
        /// 昵称和B端店铺后台客户详情昵称一致，推荐使用
        /// </summary>
        public string latest_nickname { get; set; }
        /// <summary>
        /// 客户标签
        /// </summary>
        public List<CustomerTag> tags { get; set; }
        /// <summary>
        /// 客户等级
        /// </summary>
        public int level { get; set; }
        /// <summary>
        /// 头像，和B端店铺后台客户详情头像一致，推荐使用
        /// </summary>
        public string latest_avatar { get; set; }
        /// <summary>
        /// 创建时间，Unix时间戳，单位：秒1594296126604
        /// </summary>
        public long created_at { get; set; }
        /// <summary>
        /// 微信昵称
        /// </summary>
        public string wx_nickname { get; set; }
        /// <summary>
        /// 用户等级
        /// </summary>
        public List<CustomerLevelInfo> level_infos { get; set; }
        /// <summary>
        /// 客户会员卡
        /// </summary>
        public List<CustomerCard> cards { get; set; }
        /// <summary>
        /// 优惠券数量（有效优惠券）
        /// </summary>
        public int coupon_num { get; set; }
        /// <summary>
        /// 更新时间，Unix时间戳，单位：秒1594296126604
        /// </summary>
        public long updated_at { get; set; }
        /// <summary>
        /// 微信头像
        /// </summary>
        public string wx_avatar { get; set; }
        /// <summary>
        /// 自定义信息项
        /// </summary>
        public List<CustomerAttrInfo> customer_attrInfos { get; set; }
        /// <summary>
        /// 展示姓名(包含展示逻辑：客户姓名=>手机号=>微信昵称=>匿名用户)
        /// </summary>
        public string show_name { get; set; }
        /// <summary>
        /// 客户备注
        /// </summary>
        public string remark { get; set; }
        /// <summary>
        /// 会员创建时间，Unix时间戳，单位：秒（不是会员则不会返回）1594296126604
        /// </summary>
        public long member_created_at { get; set; }
        /// <summary>
        /// 客户性别， 1:男，2:女
        /// </summary>
        public int gender { get; set; }
        /// <summary>
        /// 客户标签ids
        /// </summary>
        public List<long> tag_ids { get; set; }
        /// <summary>
        /// 区/县
        /// </summary>
        public string county_name { get; set; }
        /// <summary>
        /// 购买总金额，单位：分
        /// </summary>
        public long total_trade_amount { get; set; }
        /// <summary>
        /// 客户姓名
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 客户归属店铺，微商城单店返回单店店铺id，连锁店铺返回网店id
        /// </summary>
        public long ascription_kdt_id { get; set; }
        /// <summary>
        /// 客户积分
        /// </summary>
        public long points { get; set; }
        /// <summary>
        /// 购买次数
        /// </summary>
        public int trade_count { get; set; }
        /// <summary>
        /// 授权信息
        /// </summary>
        public CustomerAuth auth_info { get; set; }
        /// <summary>
        /// 储值余额，单位：分
        /// </summary>
        public long prepaid_balance { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string province_name { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string city_name { get; set; }
        /// <summary>
        /// 退款总金额，单位：分
        /// </summary>
        public long refund_trade_amount { get; set; }
        /// <summary>
        /// 退款次数
        /// </summary>
        public long refund_count { get; set; }
        /// <summary>
        /// 生日，年-月-日，后面的时分秒无意义1998-01-01 00:00:00
        /// </summary>
        public string birthday { get; set; }

        /// <summary>
        /// 微信号
        /// </summary>
        public string wei_xin { get; set; }

    }

    public class CustomerAuth
    {
        /// <summary>
        /// 手机号码是否授权 true:已授权 false:未授权
        /// </summary>
        public bool is_mobile_auth { get; set; }
    }

    public class CustomerAttrInfo
    {
        /// <summary>
        /// 自定义信息项名称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 自定义信息项数值
        /// </summary>
        public string value { get; set; }
    }

    public class CustomerCard
    {
        /// <summary>
        /// 权益卡名称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 权益卡唯一id
        /// </summary>
        public long id { get; set; }
        /// <summary>
        /// 规则卡的等级(1-10)，0代表非规则卡
        /// </summary>
        public int level { get; set; }
    }

    public class CustomerLevelInfo
    {
        /// <summary>
        /// 等级名称
        /// </summary>
        public string level_name { get; set; }
        /// <summary>
        /// 等级值
        /// </summary>
        public int level_value { get; set; }
        /// <summary>
        /// 等级类型 1：免费等级，2：付费等级
        /// </summary>
        public int level_type { get; set; }
    }

    public class CustomerRight
    {
        /// <summary>
        /// 权益名称:生日特权
        /// </summary>
        public string alias { get; set; }
        /// <summary>
        /// 权益描述文案
        /// </summary>
        public string description { get; set; }
        /// <summary>
        /// 权益类型 1.包邮 11.折扣 21.优惠券 31.领取送积分 41.对XX享受xx次 51.消费奖励积分的奖励倍率 61.送成长值 81.知识付费 91.发卡 92.生日特权
        /// </summary>
        public int type { get; set; }
    }
    public class CustomerTag
    {
        /// <summary>
        /// 标签名:活跃用户
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 标签id
        /// </summary>
        public long id { get; set; }
    }

    public class SendCardRequest
    {
        public SendCard @params{ get; set; }
}
    public class SendCard
    {
        ///// <summary>
        ///// 管理员id，如果是管理员发放场景，传有赞的userId，否则，adminId传0
        ///// </summary>
        //public long admin_id { get; set; }
        /// <summary>
        /// 卡别名
        /// </summary>
        public string card_alias { get; set; }
        /// <summary>
        /// 客户信息
        /// </summary>
        public UserAccount user { get; set; }
    }

    public class UserAccount
    {
        /// <summary>
        /// 帐号ID
        /// </summary>
        public string account_id { get; set; }
        /// <summary>
        /// 帐号类型（支持的客户账号类型； 1-有赞粉丝id(有赞不同的合作渠道会生成不同渠道对应在有赞平台下的fans_id) ; 2-手机号; 3-三方帐号(原open_user_id:三方App用户ID，该参数仅限购买App开店插件的商家使用) ;5-有赞用户id，用户在有赞的唯一id。推荐使用）
        /// </summary>
        public int account_type { get; set; }
    }

    public class SendCardResp
    {
        /// <summary>
        /// 权益卡号
        /// </summary>
        public string card_no { get; set; }
        /// <summary>
        /// 激活URL，当客户不属于店铺下客户的时候会返回，可以把激活链接发给客户进行激活领取
        /// </summary>
        public string validate_url { get; set; }
        /// <summary>
        /// 是否成功；true:成功 false：失败
        /// </summary>
        public bool is_success { get; set; }
    }

    public class GetCard
    {
        /// <summary>
        /// 页码，从1~100开始，分页数不能超过100页。
        /// </summary>
        public int page { get; set; }
       
    }

    public class CardResp
    {
        /// <summary>
        /// 页码，从1~100开始，分页数不能超过100页。
        /// </summary>
        public int page { get; set; }
        /// <summary>
        /// 每页条数。默认30条
        /// </summary>
        public int page_size { get; set; }
        /// <summary>
        /// 权益卡列表
        /// </summary>
        public List<YZCardInfo> items { get; set; }
        /// <summary>
        /// 权益卡总数
        /// </summary>
        public long total { get; set; }


    }

    public class YZCardInfo
    {
        /// <summary>
        /// 商家权益卡的唯一标识
        /// </summary>
        public string card_alias { get; set; }
        /// <summary>
        /// 权益卡创建时间2019-07-03 09:39:34
        /// </summary>
        public string create_time { get; set; }
        /// <summary>
        /// 发卡链接
        /// </summary>
        public string card_url { get; set; }
        /// <summary>
        /// 权益卡名称
        /// </summary>
        public string name { get; set; }
        /// <summary>
        /// 权益卡类型;3:无门槛卡,2:付费卡,1:规则卡
        /// </summary>
        public string grant_type { get; set; }
        /// <summary>
        /// 权益卡状态：使用中:true 已禁用:false
        /// </summary>
        public bool is_available { get; set; }
    }

    #region 交易订单详情4.0接口

    /// <summary>
    /// 交易订单详情4.0接口
    /// </summary>
    public class TradeResponse
    {
        /// <summary>
        /// 交易基础信息结构体
        /// </summary>
        [JsonProperty("full_order_info")]
        public FullOrderInfo FullOrderInfo { get; set; }
    }

    /// <summary>
    /// 有赞非要这么套一层
    /// </summary>
    public class FullOrderInfoModel
    {
        /// <summary>
        /// 交易基础信息结构体
        /// </summary>
        [JsonProperty("full_order_info")]
        public FullOrderInfo FullOrderInfo { get; set; }
    }

    /// <summary>
    /// 交易基础信息结构体
    /// </summary>
    public class FullOrderInfo
    {
        /// <summary>
        /// 交易明细
        /// </summary>
        [JsonProperty("orders")]
        public List<Order> Orders { get; set; }

        /// <summary>
        /// 订单支付信息
        /// </summary>
        [JsonProperty("pay_info")]
        public YzPayInfo PayInfo { get; set; }

        /// <summary>
        /// 订单买家信息
        /// </summary>
        [JsonProperty("buyer_info")]
        public BuyerInfo BuyerInfo { get; set; }

        /// <summary>
        /// 交易基础信息
        /// </summary>
        [JsonProperty("order_info")]
        public OrderInfo OrderInfo { get; set; }
    }

    /// <summary>
    /// 交易明细
    /// </summary>
    public class Order
    {
        /// <summary>
        /// 商品id，有赞生成的商品唯一值。
        /// </summary>
        [JsonProperty("item_id")]
        public int ItemId { get; set; }

        /// <summary>
        /// 仅订单是价格日历电子卡券或酒店商品类型时返回，酒店商品订单对应客户入住时间，价格日历电子卡券场景是客户游玩时间。时间格式：yyyy-MM-dd
        /// </summary>
        [JsonProperty("goods_date")]
        public string GoodsDate { get; set; }

        /// <summary>
        /// 字段已废弃
        /// </summary>
        [JsonProperty("discount")]
        public string Discount { get; set; }

        /// <summary>
        /// 订单商品扩展信息
        /// </summary>
        [JsonProperty("order_item_extra")]
        public string OrderItemExtra { get; set; }

        /// <summary>
        /// 跨境商品仓库id（仅限大客使用，标准开发者无需关注）
        /// </summary>
        [JsonProperty("warehouse_code")]
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 使用youzan.trade.order.out.create.1.0.0导入外部订单时，传入的子订单id。用于将有赞内部生成的子订单与外部导入的子订单关联。未传入时，返回空字符串
        /// </summary>
        [JsonProperty("outer_oid" )]
        public string OuterOId { get; set; }

        /// <summary>
        /// 分销单实付金额 ，单位元
        /// </summary>
        [JsonProperty("fenxiao_payment")]
        public string FenXiaoPayment { get; set; }

        /// <summary>
        /// 海淘-申报单价（完税价格）,单位：元
        /// </summary>
        [JsonProperty("goods_dutiable_price")]
        public string GoodsDutiablePrice { get; set; }

        /// <summary>
        /// 税费，单位：元
        /// </summary>
        [JsonProperty("tax_total")]
        public string TaxTotal { get; set; }

        /// <summary>
        /// 是否为预售商品，是：返回为1，否返回为空
        /// </summary>
        [JsonProperty("is_pre_sale")]
        public string IsPreSale { get; set; }

        /// <summary>
        /// 商品成本价，单位：元
        /// </summary>
        [JsonProperty("goods_cost_price")]
        public string GoodsCostPrice { get; set; }

        /// <summary>
        /// 商品留言
        /// </summary>
        [JsonProperty("buyer_messages")]
        public string BuyerMessages { get; set; }

        /// <summary>
        /// 单商品原价，单位：元
        /// </summary>
        [JsonProperty("price")]
        public string Price { get; set; }

        /// <summary>
        /// 商品名称    
        /// </summary>
        [JsonProperty("title")]
        public string Title { get; set; }

        /// <summary>
        /// 海淘商品贸易模式，BC直邮：9610，BBC保税进口：1210
        /// </summary>
        [JsonProperty("cross_border_trade_mode")]
        public string CrossBorderTradeMode { get; set; }

        /// <summary>
        /// 运杂费(仅海淘订单有该字段返回)，单位：元
        /// </summary>
        [JsonProperty("freight")]
        public string Freight { get; set; }

        /// <summary>
        /// 订单明细id
        /// </summary>
        [JsonProperty("oid")]
        public string OId { get; set; }

        /// <summary>
        /// 定金预售订单发货时间 单位：秒
        /// </summary>
        [JsonProperty("expect_delivery_time")]
        public long ExpectDeliveryTime { get; set; }

        /// <summary>
        /// 商品税费模式："1":含税模式、"0":税费分离
        /// </summary>
        [JsonProperty("tariff_rule")]
        public string TariffRule { get; set; }

        /// <summary>
        /// 订单明细应付金额，订单上每个商品最终均摊价，单位：元
        /// </summary>
        [JsonProperty("payment")]
        public string Payment { get; set; }

        /// <summary>
        /// 分销商品金额,单位：元
        /// </summary>
        [JsonProperty("fenxiao_discount_price")]
        public string FenXiaoDiscountPrice { get; set; }

        /// <summary>
        /// 网店商品-茶饮烘焙类型商品的商品属性，name为属性名称，value_name为属性值
        /// </summary>
        [JsonProperty("item_props")]
        public string ItemProps { get; set; }

        /// <summary>
        /// 是否赠品，是：true，否：false
        /// </summary>
        [JsonProperty("is_present")]
        public bool IsPresent { get; set; }

        /// <summary>
        /// 商品快照地址（定制字段，开发者无需使用）
        /// </summary>
        [JsonProperty("goods_snapshot")]
        public string GoodsSnapshot { get; set; }

        /// <summary>
        /// 是否是跨境海淘订单，是：返回为1，否返回为空
        /// </summary>
        [JsonProperty("is_cross_border")]
        public string IsCrossBorder { get; set; }

        /// <summary>
        /// 分销海淘-商品总货值（完税价格*商品数量），单位：元
        /// </summary>
        [JsonProperty("fenxiao_goods_total_dutiable_price")]
        public string FenXiaoGoodsTotalDutiablePrice { get; set; }

        /// <summary>
        /// 商品类型，0:普通商品; 1:拍卖商品; 5:餐饮商品; 10:分销商品; 20:会员卡商品; 21:礼品卡商品; 23:有赞会议商品; 24:周期购; 30:收银台商品; 31:知识付费商品; 35:酒店商品; 40:普通服务类商品; 71:卡项商品;182:普通虚拟商品; 183:电子卡券商品; 201:外部会员卡商品; 202:外部直接收款商品; 203:外部普通商品; 204:外部服务商品;205:mock不存在商品; 206:小程序二维码;207:积分充值商品;208:付费优惠券商品
        /// </summary>
        [JsonProperty("item_type")]
        public int ItemType { get; set; }

        /// <summary>
        /// 商品编码，商家自定义编码，可用于和其他系统之间商品的外部id的标识。
        /// </summary>
        [JsonProperty("outer_item_id")]
        public string OuterItemId { get; set; }

        /// <summary>
        /// 商品规格编码，sku_id值不为0时：返回商品规格编码；sku_id值为0时：当设置商品编码后且开启多网点功能，返回值为商品编码，否则返回空。
        /// </summary>
        [JsonProperty("outer_sku_id")]
        public string OuterSkuId { get; set; }

        /// <summary>
        /// 商品总价（扣除商品级优惠） 单位：元
        /// </summary>
        [JsonProperty("total_fee")]
        public string TotalFee { get; set; }

        /// <summary>
        /// 海淘订单子订单号
        /// </summary>
        [JsonProperty("sub_order_no")]
        public string SubOrderNo { get; set; }

        /// <summary>
        /// 商品规格id，有赞生成的规格id。无规格商品返回0
        /// </summary>
        [JsonProperty("sku_id")]
        public int SkuId { get; set; }

        /// <summary>
        /// 分销税费,单位：元
        /// </summary>
        [JsonProperty("fenxiao_tax_total")]
        public string FenXiaoTaxTotal { get; set; }

        /// <summary>
        /// 海淘-商品总货值（完税价格*商品数量），单位：元
        /// </summary>
        [JsonProperty("goods_total_dutiable_price")]
        public string GoodsTotalDutiablePrice { get; set; }

        /// <summary>
        /// 海淘-虚拟货币优惠金额（积分、优惠券），单位：元
        /// </summary>
        [JsonProperty("virtual_currency")]
        public string VirtualCurrency { get; set; }

        /// <summary>
        /// 海淘-促销优惠金额（不含虚拟货币优惠金额），单位：元
        /// </summary>
        [JsonProperty("promotion_discount")]
        public string PromotionDiscount { get; set; }

        /// <summary>
        /// 商品唯一编码
        /// </summary>
        [JsonProperty("sku_unique_code")]
        public string SkuUniqueCode { get; set; }

        /// <summary>
        /// 分销非现金抵扣金额,单位：元
        /// </summary>
        [JsonProperty("fenxiao_discount")]
        public string FenXiaoDiscount { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        [JsonProperty("num")]
        public int Num { get; set; }

        /// <summary>
        /// 是否为价格日历商品，是：返回为1，否返回为空
        /// </summary>
        [JsonProperty("is_price_calendar")]
        public string IsPriceCalendar { get; set; }

        /// <summary>
        /// 商品图片地址
        /// </summary>
        [JsonProperty("pic_path")]
        public string PicPath { get; set; }

        /// <summary>
        /// 0 全款预售，1 定金预售
        /// </summary>
        [JsonProperty("pre_sale_type")]
        public string PreSaleType { get; set; }

        /// <summary>
        /// 海关编号，更多海关编码请访问：https://doc.youzanyun.com/resource/solution/27031/27100
        /// </summary>
        [JsonProperty("customs_code")]
        public string CustomsCode { get; set; }

        /// <summary>
        /// 分销运费,单位：元
        /// </summary>
        [JsonProperty("fenxiao_freight")]
        public string FenXiaoFreight { get; set; }

        /// <summary>
        /// 商品别名
        /// </summary>
        [JsonProperty("alias")]
        public string Alias { get; set; }

        /// <summary>
        /// 总部商品id（零售连锁版本特有字段）
        /// </summary>
        [JsonProperty("root_item_id")]
        public long RootItemId { get; set; }

        /// <summary>
        /// 商品详情链接
        /// </summary>
        [JsonProperty("goods_url")]
        public string GoodsUrl { get; set; }

        /// <summary>
        /// 单商品现价，减去了商品的优惠金额。单位：元
        /// </summary>
        [JsonProperty("discount_price")]
        public string DiscountPrice { get; set; }

        /// <summary>
        /// 商品积分价（非积分商品则为0），如返回值是100则表示100积分。
        /// </summary>
        [JsonProperty("points_price")]
        public string PointsPrice { get; set; }

        /// <summary>
        /// 商品规格信息（无规格商品为空）
        /// </summary>
        [JsonProperty("sku_properties_name")]
        public string SkuPropertiesName { get; set; }

        /// <summary>
        /// 商品重量 单位是 g
        /// </summary>
        [JsonProperty("weight")]
        public string Weight { get; set; }

        /// <summary>
        /// 总部商品规格id（零售连锁版本特有字段）
        /// </summary>
        [JsonProperty("root_sku_id")]
        public long RootSkuId { get; set; }

        /// <summary>
        /// 海淘-非现金抵扣金额（元）
        /// </summary>
        [JsonProperty("haitao_discount")]
        public string HaiTaoDiscount { get; set; }

        /// <summary>
        /// 分销单金额 ，单位元
        /// </summary>
        [JsonProperty("fenxiao_price")]
        public string FenXiaoPrice { get; set; }
    }

    /// <summary>
    /// 订单支付信息
    /// </summary>
    public class YzPayInfo
    {
        /// <summary>
        /// 多阶段支付信息
        /// </summary>
        [JsonProperty("phase_payments")]
        public List<PhasePayment> PhasePayments { get; set; }

        /// <summary>
        /// 订单整单实付价格 单位：元
        /// </summary>
        [JsonProperty("real_payment")]
        public string RealPayment { get; set; }

        /// <summary>
        /// 商品总价，单位元
        /// </summary>
        [JsonProperty("total_fee")]
        public string TotalFee { get; set; }

        /// <summary>
        /// 订单整单应付金额，单位：元
        /// </summary>
        [JsonProperty("payment")]
        public string Payment { get; set; }

        /// <summary>
        /// 外部订单号（即微信端交易单号）
        /// </summary>
        [JsonProperty("outer_transactions")]
        public List<string> OuterTransactions { get; set; }

        /// <summary>
        /// 礼品卡/储值卡抵扣之后的订单实付金额 单位：分
        /// </summary>
        [JsonProperty("deduction_real_pay")]
        public long DeductionRealPay { get; set; }

        /// <summary>
        /// 礼品卡/储值卡具体抵扣的金额，单位：分
        /// </summary>
        [JsonProperty("deduction_pay")]
        public long DeductionPay { get; set; }
    }

    /// <summary>
    /// 多阶段支付信息
    /// </summary>
    public class PhasePayment
    {
        /// <summary>
        /// 订单支付时间，时间格式为yyyy年-MM月-dd日 HH时:mm分:ss秒
        /// </summary>
        [JsonProperty("pay_time")]
        public DateTime PayTime { get; set; }

        /// <summary>
        /// 内部支付流水号
        /// </summary>
        [JsonProperty("inner_transaction_no")]
        public string InnerTransactionNo { get; set; }

        /// <summary>
        /// 支付开始时间，时间格式为yyyy年-MM月-dd日 HH时:mm分:ss秒
        /// </summary>
        [JsonProperty("pay_start_time")]
        public DateTime PayStartTime { get; set; }

        /// <summary>
        /// 支付类型。取值范围： WEIXIN (微信自有支付) WEIXIN_DAIXIAO (微信代销支付) ALIPAY (支付宝支付) BANKCARDPAY (银行卡支付) PEERPAY (代付) CODPAY (货到付款) BAIDUPAY (百度钱包支付) PRESENTTAKE (直接领取赠品) COUPONPAY(优惠券/码全额抵扣) BULKPURCHASE(来自分销商的采购) MERGEDPAY(合并付货款) ECARD(有赞E卡支付) PURCHASE_PAY (采购单支付) MARKPAY (标记收款) OFCASH (现金支付) PREPAIDCARD (储值卡余额支付)ENCHASHMENT_GIFT_CARD(礼品卡支付)
        /// </summary>
        [JsonProperty("pay_way_str")]
        public string PayWayStr { get; set; }

        /// <summary>
        /// 支付阶段；1表示第一支付阶段，如定金预售的付定金阶段，2表示第二支付阶段，如定金预售的付尾款
        /// </summary>
        [JsonProperty("phase")]
        public int Phase { get; set; }

        /// <summary>
        /// 阶段支付应付金额，单位元
        /// </summary>
        [JsonProperty("real_price")]
        public string RealPrice { get; set; }

        /// <summary>
        /// 支付结束时间，时间格式为yyyy年-MM月-dd日 HH时:mm分:ss秒
        /// </summary>
        [JsonProperty("pay_end_time")]
        public DateTime PayEndTime { get; set; }

        /// <summary>
        /// 外部支付流水号
        /// </summary>
        [JsonProperty("outer_transaction_no")]
        public string OuterTransactionNo { get; set; }
    }

    /// <summary>
    /// 订单买家信息
    /// </summary>
    public class BuyerInfo
    {
        /// <summary>
        /// 粉丝昵称
        /// </summary>
        [JsonProperty("fans_nickname")]
        public string FansNickname { get; set; }

        /// <summary>
        /// 粉丝id
        /// </summary>
        [JsonProperty("fans_id")]
        public long FansId { get; set; }

        /// <summary>
        /// 粉丝类型0:未知、1:微信自有粉丝; 9:代销粉丝,2:微博,105:,知乎,128: 有赞精选app,188: QQ,312:腾讯云,736:支付宝,1180:百度,1181:今日头条,1590:微信广告,56473:陌陌 ,59011:线下微信支付产生的粉丝,59465:线下支付宝支付,4591:有人,16940: 快手 ,26879:上鱼,6227:精选小程序,61489:虎牙
        /// </summary>
        [JsonProperty("fans_type")]
        public long FansType { get; set; }

        /// <summary>
        /// 买家手机号
        /// </summary>
        [JsonProperty("buyer_phone")]
        public string BuyerPhone { get; set; }

        /// <summary>
        /// 微信H5和微信小程序（有赞小程序和小程序插件）的订单会返回微信weixin_openid，三方App（有赞APP开店）的订单会返回open_user_id，2019年1月30号后的订单支持返回该参数
        /// </summary>
        [JsonProperty("outer_user_id")]
        public string OuterUserId { get; set; }

        /// <summary>
        /// 有赞对外统一openId
        /// </summary>
        [JsonProperty("yz_open_id")]
        public string YzOpenId { get; set; }
    }

    /// <summary>
    /// 交易基础信息
    /// </summary>
    public class OrderInfo
    {
        /// <summary>
        /// 订单打标
        /// </summary>
        [JsonProperty("order_tags")]
        public OrderTags OrderTags { get; set; }

        /// <summary>
        /// 是否零售订单
        /// </summary>
        [JsonProperty("is_retail_order")]
        public bool? IsRetailOrder { get; set; }

        /// <summary>
        /// 支付类型; 0:默认值,未支付; 1:微信自有支付; 2:支付宝wap; 3:支付宝wap; 5:财付通; 7:代付; 8:联动优势; 9:货到付款; 10:大账号代销; 11:受理模式; 12:百付宝; 13:sdk支付; 14:合并付货款; 15:赠品; 16:优惠兑换; 17:自动付货款; 18:爱学贷; 19:微信wap; 20:微信红包支付; 21:返利; 22:ump红包; 24:易宝支付; 25:储值卡; 27:qq支付; 28:有赞E卡支付; 29:微信条码; 30:支付宝条码; 33:礼品卡支付; 35:会员余额;37:储蓄卡银联支付;40:分期支付;49:先用后付; 72:微信扫码二维码支付; 80:待结算&余额支付;90:礼品卡支付;100:代收账户; 300:储值账户; 400:保证金账户; 101:收款码; 102:微信; 103:支付宝; 104:刷卡; 105:二维码台卡; 106:储值卡; 107:有赞E卡; 110:标记收款-自有微信支付; 111:标记收款-自有支付宝; 112:标记收款-自有POS刷卡; 113:通联刷卡支付;114:标记收款-自定义;115:有赞零钱支付;116:优惠全额抵扣;117:商米支付118:商米支付-支付宝;119:商米pos;200:记账账户;201:现金;202:组合支付;203:外部支付;204:汇款支付;205:标记收款-挂账支付;206:对公转账;300:储值账户;400:保证金账户;4093:农行商E付;4095:花呗支付;4096, "支付宝免密支付;4097:支付宝-用户付;4101:银联网银支付;
        /// </summary>
        [JsonProperty("pay_type")]
        public long? PayType { get; set; }

        /// <summary>
        /// 订单更新时间
        /// </summary>
        [JsonProperty("update_time")]
        public DateTime? UpdateTime { get; set; }

        /// <summary>
        /// 多网点id，非多网点订单，返回为空
        /// </summary>
        [JsonProperty("offline_id")]
        public long? OfflineId { get; set; }

        /// <summary>
        /// 订单发货时间（当所有商品发货后才会更新）
        /// </summary>
        [JsonProperty("consign_time")]
        public DateTime? ConsignTime { get; set; }

        /// <summary>
        /// 订单号
        /// </summary> 
        [JsonProperty("tid")]
        public string Tid { get; set; }

        /// <summary>
        /// 订单扩展信息
        /// </summary>
        [JsonProperty("order_extra")]
        public JObject OrderExtra { get; set; }

        /// <summary>
        /// 订单创建时间
        /// </summary>
        [JsonProperty("created")]
        public DateTime? Created { get; set; }

        /// <summary>
        /// 主订单状态 WAIT_BUYER_PAY （等待买家付款，定金预售描述：定金待付、等待尾款支付开始、尾款待付）； TRADE_PAID（订单已支付 ）； WAIT_CONFIRM（待确认，包含待成团、待接单等等。即：买家已付款，等待成团或等待接单）； WAIT_SELLER_SEND_GOODS（等待卖家发货，即：买家已付款）； WAIT_BUYER_CONFIRM_GOODS (等待买家确认收货，即：卖家已发货) ； TRADE_SUCCESS（买家已签收以及订单成功）； TRADE_CLOSED（交易关闭）； PS：TRADE_PAID状态仅代表当前订单已支付成功，表示瞬时状态，稍后会自动修改成后面的状态。如果不关心此状态请再次请求详情接口获取下一个状态。
        /// </summary>
        [JsonProperty("status")]
        public string Status { get; set; }

        /// <summary>
        /// 总店id
        /// </summary>
        [JsonProperty("root_kdt_id")]
        public long? RootKdtId { get; set; }

        /// <summary>
        /// 店铺类型 0:微商城; 1:微小店; 2:爱学贷微商城; 3:批发店铺; 4:批发商城; 5:外卖; 6:美业; 7:超级门店; 8:收银; 9:收银加微商城; 10:零售总部; 99:有赞开放平台平台型应用创建的店铺
        /// </summary>
        [JsonProperty("team_type")]
        public long? TeamType { get; set; }

        /// <summary>
        /// 订单过期时间（未付款将自动关单）
        /// </summary>
        [JsonProperty("expired_time")]
        public DateTime? ExpiredTime { get; set; }

        /// <summary>
        /// 退款状态 0:未退款; 2:部分退款成功; 12:全额退款成功
        /// </summary>
        [JsonProperty("refund_state")]
        public long? RefundState { get; set; }

        /// <summary>
        /// 物流类型 0:快递发货; 1:到店自提; 2:同城配送; 9:无需发货（虚拟商品订单）
        /// </summary>
        [JsonProperty("express_type")]
        public long? ExpressType { get; set; }

        /// <summary>
        /// 主订单类型0:普通订单; 1:送礼订单; 2:代付; 3:供货商查询时返回表示为分销供货单。; 4:赠品; 5:心愿单; 6:二维码订单; 7:合并付货款; 8:1分钱实名认证; 9:品鉴; 10:拼团; 15:返利; 35:酒店; 40:外卖; 41:堂食点餐; 46:外卖买单; 51:全员开店; 61:线下收银台订单; 71:美业预约单; 72:美业服务单; 75:知识付费; 81:礼品卡;85：直播带货订单（仅指爱逛平台产生的订单） 100:批发
        /// </summary>
        [JsonProperty("type")]
        public long? Type { get; set; }

        /// <summary>
        /// 订单支付时间
        /// </summary>
        [JsonProperty("pay_time")]
        public DateTime? PayTime { get; set; }

        /// <summary>
        /// 支付类型。取值范围： WEIXIN (微信自有支付) WEIXIN_DAIXIAO (微信代销支付) ALIPAY (支付宝支付) BANKCARDPAY (银行卡支付) PEERPAY (代付) CODPAY (货到付款) BAIDUPAY (百度钱包支付) PRESENTTAKE (直接领取赠品) COUPONPAY(优惠券/码全额抵扣) BULKPURCHASE(来自分销商的采购) MERGEDPAY(合并付货款) ECARD(有赞E卡支付) PURCHASE_PAY (采购单支付) MARKPAY (标记收款) OFCASH (现金支付) PREPAIDCARD (储值卡余额支付)ENCHASHMENT_GIFT_CARD(礼品卡支付)
        /// </summary>
        [JsonProperty("pay_type_str")]
        public string PayTypeStr { get; set; }
    }

    /// <summary>
    /// 订单打标
    /// </summary>
    public class OrderTags
    {
        /// <summary>
        /// 是否分销单
        /// </summary>
        [JsonProperty("is_fenxiao_order")]
        public bool IsFenXiaoOrder { get; set; }

        /// <summary>
        /// 是否支付
        /// </summary>
        [JsonProperty("is_payed")]
        public bool IsPayed { get; set; }

        /// <summary>
        /// 是否线下订单
        /// </summary>
        [JsonProperty("is_offline_order")]
        public bool IsOfflineOrder { get; set; }

        /// <summary>
        /// 是否定金预售
        /// </summary>
        [JsonProperty("is_down_payment_pre")]
        public bool IsDownPaymentPre { get; set; }

        /// <summary>
        /// 是否会员订单
        /// </summary>
        [JsonProperty("is_member")]
        public bool IsMember { get; set; }

        /// <summary>
        /// 是否担保交易
        /// </summary>
        [JsonProperty("is_secured_transactions")]
        public bool IsSecuredTransactions { get; set; }

        /// <summary>
        /// 是否有退款
        /// </summary>
        [JsonProperty("is_refund")]
        public bool IsRefund { get; set; }

        /// <summary>
        /// 是否虚拟订单
        /// </summary>
        [JsonProperty("is_virtual")]
        public bool IsVirtual { get; set; }

        /// <summary>
        /// 是否享受免邮
        /// </summary>
        [JsonProperty("is_postage_free")]
        public bool IsPostageFree { get; set; }

        /// <summary>
        /// 是否结算
        /// </summary>
        [JsonProperty("is_settle")]
        public bool IsSettle { get; set; }

        /// <summary>
        /// 是否有维权
        /// </summary>
        [JsonProperty("is_feedback")]
        public bool IsFeedback { get; set; }

        /// <summary>
        /// 是否采购单
        /// </summary>
        [JsonProperty("is_purchase_order")]
        public bool IsPurchaseOrder { get; set; }

        /// <summary>
        /// 是否多门店订单
        /// </summary>
        [JsonProperty("is_multi_store")]
        public bool IsMultiStore { get; set; }
    }

    #endregion

    #region 订单搜索接口

    /// <summary>
    /// 订单搜索接口请求参数
    /// </summary>
    public class GetTradesSoldRequest
    {
        /// <summary>
        /// 通用搜索字段，使用底层符合条件查询搜索,订单号、收货人手机号、收货人手机号后四位
        /// </summary>
        [JsonProperty("keywords")]
        public string Keywords { get; set; }

        /// <summary>
        /// 有赞对外统一openId
        /// </summary>
        [JsonProperty("yz_open_id")]
        public string YzOpenId { get; set; }

        /// <summary>
        /// 订单类型NORMAL：普通订单；PEERPAY：代付；GIFT：我要送人；FX_CAIGOUDAN：分销供货单；PRESENT：赠品；WISH：心愿单；QRCODE：二维码订单；QRCODE_3RD：线下收银台订单；FX_MERGED：合并付货款；VERIFIED：1分钱实名认证；PINJIAN：品鉴；REBATE：返利；FX_QUANYUANDIAN：全员开店；FX_DEPOSIT：保证金；PF：批发；GROUP：拼团；HOTEL：酒店；TAKE_AWAY：外卖；CATERING_OFFLINE：堂食点餐；CATERING_QRCODE：外卖买单；BEAUTY_APPOINTMENT：美业预约单；BEAUTY_SERVICE：美业服务单；KNOWLEDGE_PAY：知识付费；GIFT_CARD：礼品卡（参照微商城模块）
        /// </summary>
        [JsonProperty("type")]
        public string Type { get; set; }

        /// <summary>
        /// 是否需要返回订单url
        /// </summary>
        [JsonProperty("need_order_url")]
        public bool? NeedOrderUrl { get; set; } 

        /// <summary>
        /// 订单号
        /// </summary>
        [JsonProperty("tid")]
        public string Tid { get; set; }

        /// <summary>
        /// 子店kdtId
        /// </summary>
        [JsonProperty("node_kdt_id")]
        public long? NodeKdtId { get; set; }

        /// <summary>
        /// 同城送预计送达时间-开始时间，时间格式：yyyy-MM-dd-HH-mm-ss；开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("delivery_start_time")]
        public DateTime? DeliveryStartTime { get; set; }

        /// <summary>
        /// 按订单完成时间结束 例:2017-01-01 12:00:00; 开始时间和结束时间的跨度不能大于3个月; 结束时间必须大于开始时间; 开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("end_success")]
        public DateTime? EndSuccess { get; set; }

        /// <summary>
        /// 按订单完成时间开始 例:2017-01-01 12:00:00; 开始时间和结束时间的跨度不能大于3个月; 结束时间必须大于开始时间; 开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("start_success")]
        public DateTime? StartSuccess { get; set; }

        /// <summary>
        /// 收货人昵称
        /// </summary>
        [JsonProperty("receiver_name")]
        public string ReceiverName { get; set; }

        /// <summary>
        /// 按订单创建时间开始开始时间和结束时间的跨度不能大于3个月;结束时间必须大于开始时间;开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("start_created")]
        public string StartCreated { get; set; }

        /// <summary>
        /// 每页条数，默认 20 条，最大不能超过100，建议使用默认分页。
        /// </summary>
        [JsonProperty("page_size")]
        public int? PageSize { get; set; }

        /// <summary>
        /// 同城送预计送达时间-结束时间，时间格式：yyyy-MM-dd-HH-mm-ss；开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("delivery_end_time")]
        public DateTime? DeliveryEndTime { get; set; }

        /// <summary>
        /// 按订单创建时间结束例:2017-01-01 12:00:00;开始时间和结束时间的跨度不能大于3个月;结束时间必须大于开始时间;开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("end_created")]
        public string EndCreated { get; set; }

        /// <summary>
        /// 门店id
        /// </summary>
        [JsonProperty("offline_id")]
        public long? OfflineId { get; set; }

        /// <summary>
        /// 商品id，有赞生成的商品唯一id
        /// </summary>
        [JsonProperty("goods_id")]
        public long? GoodsId { get; set; }

        /// <summary>
        /// 按订单更新时间结束例:2017-01-01 12:00:00;开始时间和结束时间的跨度不能大于3个月;结束时间必须大于开始时间;开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("end_update")]
        public DateTime? EndUpdate { get; set; }

        /// <summary>
        /// 粉丝类型，0:未知、1:微信自有粉丝; 9:代销粉丝,2:微博,105:,知乎,128: 有赞精选app,188: QQ,312:腾讯云,736:支付宝,1180:百度,1181:今日头条,1590:微信广告,56473:陌陌 ,59011:线下微信支付产生的粉丝,59465:线下支付宝支付,4591:有人,16940: 快手 ,26879:上鱼,6227:精选小程序,61489:虎牙
        /// </summary>
        [JsonProperty("fans_type")]
        public int? FansType { get; set; }

        /// <summary>
        /// 页码，从 1 开始。页码最大不能超过100，如需查询更多内容，可以按照时间等其他搜索条件分多次查询。
        /// </summary>
        [JsonProperty("page_no")]
        public int? PageNo { get; set; }

        /// <summary>
        /// 按订单更新时间开始例:2017-01-01 12:00:00;开始时间和结束时间的跨度不能大于3个月;结束时间必须大于开始时间;开始时间和结束时间必须成对出现
        /// </summary>
        [JsonProperty("start_update")]
        public DateTime? StartUpdate { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        [JsonProperty("goods_title")]
        public string GoodsTitle { get; set; }

        /// <summary>
        /// 要排除的订单标签，（例如排除已开票订单，传入IS_INVOICED）；REFUND-是否退款；USE_UMP_PROMOTION-是否有优惠；IS_VIRTUAL-是否虚拟；IS_PAYED-是否经过支付；FEEDBACK-是否有维权；IS_MEMBER-是否为会员订单"), IS_FENXIAO_ORDER-是否是分销订单”)；IS_PURCHASE_ORDER-是否是采购单；USE_UMP_COUPON-是否使用了优惠券或码；IS_INVOICED-订单是否已开发票；IS_DOWN_PAYMENT_PRE-是否为定金预售订单；FULL_REFUND-是否有全额退款； IS_CROSS_BORDER-是否跨境海淘订单；MALL_GROUP_BUY-群团购订单；USE_PAY_UMP_PROMOTION-是否使用了支付营销优惠；EXCHANGE_GOODS-是否存在换货成功；IS_FISSION_ORDER-是否内购活动订单；WX_GUARANTEE,是否微信交易保障；SOLITAIRE_BUY- 社群接龙订单,IS_PRESCRIPTION_DRUG_ORDER-处方药订单
        /// </summary>
        [JsonProperty("exclude_order_tag")]
        public string ExcludeOrderTag { get; set; }

        /// <summary>
        /// 收货人手机号
        /// </summary>
        [JsonProperty("receiver_phone")]
        public string ReceiverPhone { get; set; }

        /// <summary>
        /// 订单状态，一次只能查询一种状态待付款：WAIT_BUYER_PAY待发货：WAIT_SELLER_SEND_GOODS等待买家确认：WAIT_BUYER_CONFIRM_GOODS订单完成：TRADE_SUCCESS订单关闭：TRADE_CLOSE（新增-参照微商城模块）退款中：TRADE_REFUND
        /// </summary>
        [JsonProperty("status")]
        public string Status { get; set; }

        /// <summary>
        /// 粉丝id
        /// </summary>
        [JsonProperty("fans_id")]
        public long? FansId { get; set; }

        /// <summary>
        /// 物流类型搜索，同城送订单：LOCAL_DELIVERY，自提订单：SELF_FETCH，快递配送：EXPRESS
        /// </summary>
        [JsonProperty("express_type")]
        public string ExpressType { get; set; }
    }

    /// <summary>
    /// 订单搜索接口响应参数
    /// </summary>
    public class GetTradesSoldResponse
    {
        /// <summary>
        /// 交易基础信息结构体
        /// </summary>
        [JsonProperty("full_order_info_list")]
        public List<TradesSoldFullOrderInfoModel> FullOrderInfoList { get; set; }

        /// <summary>
        /// 
        /// </summary>
        [JsonProperty("total_results")]
        public int TotalResults { get; set; }
    }

    /// <summary>
    /// 
    /// </summary>
    public class TradesSoldFullOrderInfoModel
    {
        /// <summary>
        /// 交易基础信息结构体
        /// </summary>
        [JsonProperty("full_order_info")]
        public TradesSoldFullOrderInfo FullOrderInfo { get; set; }
    }

    /// <summary>
    /// 交易基础信息结构体
    /// </summary>
    public class TradesSoldFullOrderInfo
    {
        /// <summary>
        /// 交易明细
        /// </summary>
        [JsonProperty("orders")]
        public List<TradesSoldOrder> Orders { get; set; }

        /// <summary>
        /// 交易基础信息
        /// </summary>
        [JsonProperty("order_info")]
        public OrderInfo OrderInfo { get; set; }

        /// <summary>
        /// 订单买家信息
        /// </summary>
        [JsonProperty("buyer_info")]
        public BuyerInfo BuyerInfo { get; set; }
    }

    /// <summary>
    /// 交易明细
    /// </summary>
    public class TradesSoldOrder
    {
        /// <summary>
        /// 商品图片地址
        /// </summary>
        [JsonProperty("pic_path")]
        public string PicPath { get; set; }

        /// <summary>
        /// 单商品原价 单位:元
        /// </summary>
        [JsonProperty("price")]
        public string Price { get; set; }

        /// <summary>
        /// 税费，单位元
        /// </summary>
        [JsonProperty("tax_total")]
        public string TaxTotal { get; set; }

        /// <summary>
        /// 规格id（无规格商品为0）
        /// </summary>
        [JsonProperty("sku_id")]
        public long? SkuId { get; set; }

        /// <summary>
        /// 商品别名
        /// </summary>
        [JsonProperty("alias")]
        public string Alias { get; set; }

        /// <summary>
        /// 海淘子订单号（仅海淘订单会返回）
        /// </summary>
        [JsonProperty("sub_order_no")]
        public string SubOrderNo { get; set; }

        /// <summary>
        /// 运杂费，单位元
        /// </summary>
        [JsonProperty("freight")]
        public string Freight { get; set; }

        /// <summary>
        /// 分销税费，单位元
        /// </summary>
        [JsonProperty("fenxiao_tax_total")]
        public string FenXiaoTaxTotal { get; set; }

        /// <summary>
        /// 商品规格编码
        /// </summary>
        [JsonProperty("outer_sku_id")]
        public string OuterSkuId { get; set; }

        /// <summary>
        /// 海关编号
        /// </summary>
        [JsonProperty("customs_code")]
        public string CustomsCode { get; set; }

        /// <summary>
        /// 0 全款预售，1 定金预售
        /// </summary>
        [JsonProperty("pre_sale_type")]
        public string PreSaleType { get; set; }

        /// <summary>
        /// 订单类型，0:普通类型商品; 1:拍卖商品; 5:餐饮商品; 10:分销商品; 20:会员卡商品; 21:礼品卡商品; 23:有赞会议商品; 24:周期购; 30:收银台商品; 31:知识付费商品; 35:酒店商品; 40:普通服务类商品; 71:卡项商品;182:普通虚拟商品; 183:电子卡券商品; 201:外部会员卡商品; 202:外部直接收款商品; 203:外部普通商品; 204:外部服务商品;205:mock不存在商品; 206:小程序二维码;207:积分充值商品;208:付费优惠券商品
        /// </summary>
        [JsonProperty("item_type")]
        public long? ItemType { get; set; }

        /// <summary>
        /// 商品数量
        /// </summary>
        [JsonProperty("num")]
        public long? Num { get; set; }

        /// <summary>
        /// 分销商品单价，单位元
        /// </summary>
        [JsonProperty("fenxiao_discount_price")]
        public string FenXiaoDiscountPrice { get; set; }

        /// <summary>
        /// 商品详情链接
        /// </summary>
        [JsonProperty("goods_url")]
        public string GoodsUrl { get; set; }

        /// <summary>
        /// 分销单金额 ，单位元
        /// </summary>
        [JsonProperty("fenxiao_price")]
        public string FenXiaoPrice { get; set; }

        /// <summary>
        /// 商品名称
        /// </summary>
        [JsonProperty("title")]
        public string Title { get; set; }

        /// <summary>
        /// 分销非现金抵扣金额，单位元
        /// </summary>
        [JsonProperty("fenxiao_discount")]
        public string FenXiaoDiscount { get; set; }

        /// <summary>
        /// 分销运杂费，单位元
        /// </summary>
        [JsonProperty("fenxiao_freight")]
        public string FenXiaoFreight { get; set; }

        /// <summary>
        /// 是否为预售商品 如果是预售商品则为1
        /// </summary>
        [JsonProperty("is_pre_sale")]
        public string IsPreSale { get; set; }

        /// <summary>
        /// 商品重量 单位 克
        /// </summary>
        [JsonProperty("weight")]
        public string Weight { get; set; }

        /// <summary>
        /// 海淘商品贸易模式
        /// </summary>
        [JsonProperty("cross_border_trade_mode")]
        public string CrossBorderTradeMode { get; set; }

        /// <summary>
        /// 规格信息（无规格商品为空）
        /// </summary>
        [JsonProperty("sku_properties_name")]
        public string SkuPropertiesName { get; set; }

        /// <summary>
        /// 订单明细id
        /// </summary>
        [JsonProperty("oid")]
        public string Oid { get; set; }

        /// <summary>
        /// 商品最终均摊价 单位:元
        /// </summary>
        [JsonProperty("payment")]
        public string Payment { get; set; }

        /// <summary>
        /// 非现金抵扣金额，单位元
        /// </summary>
        [JsonProperty("discount")]
        public string Discount { get; set; }

        /// <summary>
        /// 是否是跨境海淘订单("1":是,"0":否)
        /// </summary>
        [JsonProperty("is_cross_border")]
        public string IsCrossBorder { get; set; }

        /// <summary>
        /// 商品积分价（非积分商品则为0）
        /// </summary>
        [JsonProperty("points_price")]
        public string PointsPrice { get; set; }

        /// <summary>
        /// 是否赠品
        /// </summary>
        [JsonProperty("is_present")]
        public bool? IsPresent { get; set; }

        /// <summary>
        /// 商品唯一编码
        /// </summary>
        [JsonProperty("sku_unique_code")]
        public string SkuUniqueCode { get; set; }

        /// <summary>
        /// 订单条目打标
        /// </summary>
        [JsonProperty("item_tags")]
        public TradesSoldOrderItemTags ItemTags { get; set; }

        /// <summary>
        /// 商品编码
        /// </summary>
        [JsonProperty("outer_item_id")]
        public string OuterItemId { get; set; }

        /// <summary>
        /// 商品id，有赞生成的商品唯一id
        /// </summary>
        [JsonProperty("item_id")]
        public long? ItemId { get; set; }

        /// <summary>
        /// 单商品现价，减去了商品的优惠金额 单位:元
        /// </summary>
        [JsonProperty("discount_price")]
        public string DiscountPrice { get; set; }

        /// <summary>
        /// 商品留言
        /// </summary>
        [JsonProperty("buyer_messages")]
        public string BuyerMessages { get; set; }

        /// <summary>
        /// 分销单实付金额，单位元
        /// </summary>
        [JsonProperty("fenxiao_payment")]
        public string FenXiaoPayment { get; set; }

        /// <summary>
        /// 商品优惠后总价 单位:元
        /// </summary>
        [JsonProperty("total_fee")]
        public string TotalFee { get; set; }
    }

    /// <summary>
    /// 订单条目打标
    /// </summary>
    public class TradesSoldOrderItemTags
    {
        /// <summary>
        /// 是否已发货，电子卡券，虚拟商品无发货标识
        /// </summary>
        [JsonProperty("is_deliver_goods")]
        public bool IsDeliverGoods { get; set; }
    }

    #endregion

    #region 订单支付成功

    /// <summary>
    /// 订单支付成功消息体
    /// </summary>
    public class TradePaidPushDto
    { 
        /// <summary>
        /// 交易基础信息结构体
        /// </summary>
        public FullOrderInfo full_order_info { get; set; }
    }

    #endregion

    #region 单项解密

    /// <summary>
    /// 单项解密请求参数
    /// </summary>
    public class DecryptSingleRequest
    {
        /// <summary>
        /// 需解密的内容,请求此接口的token所属店铺需要与生成密文时请求的店铺保持一致
        /// </summary>
        [JsonProperty("source")]
        public string Source { get; set; }
    }

    #endregion
}
