﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class IdCardModel
    {
    }

    public class IdCardDataResult
    {
        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 名族
        /// </summary>
        public string Nation { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 地址
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 身份证号
        /// </summary>
        public string Id { get; set; }

        /// <summary>
        /// 签发机关
        /// </summary>
        public string IssueAuthority { get; set; }

        /// <summary>
        /// 签发日期
        /// </summary>
        public string IssueDate { get; set; }

        /// <summary>
        /// 失效日期
        /// </summary>
        public string ExpirationDate { get; set; }

        /// <summary>
        /// 是否为正面
        /// </summary>
        public bool IsMainSide { get; set; }
    }
    public class IdCard
    {
        public string BaseStr { get; set; }
    }

    public class CardInfo
    {
        public string BaseStr { get; set; }
    }

    public class PassportDataResult
    {
        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 姓名拼音
        /// </summary>
        public string NamePinYin { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 国籍
        /// </summary>
        public string Nation { get; set; }
        /// <summary>
        /// 国家码
        /// </summary>
        public string NationCode { get; set; }

        /// <summary>
        /// 出生地点
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 护照号码
        /// </summary>
        public string PassportId { get; set; }

        /// <summary>
        /// 签发机关
        /// </summary>
        public string IssueAuthority { get; set; }
        /// <summary>
        /// 护照签发地点
        /// </summary>
        public string IssueAddress { get; set; }
        /// <summary>
        /// 签发日期
        /// </summary>
        public string IssueDate { get; set; }

        /// <summary>
        /// 有效期至
        /// </summary>
        public string ExpirationDate { get; set; }


    }

    //港澳通行证
    public class HKMacauDataResult
    {
        /// <summary>
        /// 中文名
        /// </summary>
        public string NameChn { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 英文名
        /// </summary>
        public string NameEng { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public string Sex { get; set; }

        /// <summary>
        /// 证件号
        /// </summary>
        public string CardNum { get; set; }

        /// <summary>
        /// 出生地点
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 有效期
        /// </summary>
        public string ValidDate { get; set; }
    }

    //台湾通行证
    public class TaiWanDataResult
    {
        /// <summary>
        /// 中文名
        /// </summary>
        public string NameChn { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 英文名
        /// </summary>
        public string NameEng { get; set; }

        /// <summary>
        /// 性别
        /// </summary>
        public string Sex { get; set; }

        /// <summary>
        /// 证件号
        /// </summary>
        public string CardNum { get; set; }

        /// <summary>
        /// 出生地点
        /// </summary>
        public string Address { get; set; }

        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 有效期
        /// </summary>
        public string ValidDate { get; set; }
    }

    public class AccessToken
    {
        public string refresh_token { get; set; }
        public string expires_in { get; set; }
        public string scope { get; set; }
        public string session_key { get; set; }
        public string access_token { get; set; }
        public string session_secret { get; set; }
    }

    public class ShortQuest
    {
        public List<ShortUrl> urls { get; set; } = new List<ShortUrl>();

    }
    public class ShortUrl
    {
        public string LongUrl { get; set; }
        public string TermOfValidity { get; set; } = "1-year";
    }


    public class ShortModel
    {
        public int Code { get; set; }
        public List<ShortUrls> ShortUrls { get; set; }
    }

    public class ShortUrls
    {
        public string ShortUrl { get; set; }
        public string LongUrl { get; set; }
    }
}
