﻿using System.Collections.Generic;
using System.IO;

namespace ASHermed.SinoInterface.Api.ContractModel.SMTP
{
    /// <summary>
    /// 发送邮件请求参数
    /// </summary>
    public class EmailSendInput
    {
        /// <summary>
        /// ctor
        /// </summary>
        public EmailSendInput()
        {
            To = new List<string>();
            Attachments = new Dictionary<string, Stream>();
        }

        /// <summary>
        /// 标题
        /// </summary>
        public string Subject { get; set; }

        /// <summary>
        /// html正文
        /// </summary>
        public string HtmlBody { get; set; }
         
        /// <summary>
        /// 文本正文
        /// </summary>
        public string TextBody { get; set; }

        /// <summary>
        /// 接收人
        /// </summary>
        public List<string> To { get; set; }

        /// <summary>
        /// 附件
        /// </summary>
        public Dictionary<string, Stream> Attachments { get; set; }
    }
}
