﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Payment.Param
{
    /// <summary>
    /// 预约推送
    /// </summary>
    public class ReVisitComfirmParam
    {
        /// <summary>
        /// 调用授权码固定Sino
        /// </summary>
        public string AccessToken { get; set; }
        /// <summary>
        /// 用户标识
        /// </summary>
        public string OpenUserID { get; set; }
        /// <summary>
        /// 手机号
        /// </summary>
        public string Tel { get; set; }
        /// <summary>
        /// HIS里的PID
        /// </summary>
        public string PatientID { get; set; }
        /// <summary>
        /// 就诊人卡号
        /// </summary>
        public string CardNo { get; set; }
        /// <summary>
        /// 就诊人卡类型[0]自费卡 [1]医保卡
        /// </summary>
        public string CardType { get; set; }
        /// <summary>
        /// 患者姓名
        /// </summary>
        public string PatientName { get; set; }
        /// <summary>
        /// 身份证
        /// </summary>
        public string IDCard { get; set; }
        /// <summary>
        /// 证件类型[0]身份证 [1]护照 [2]港澳通行证
        /// </summary>
        public string CertType { get; set; }
        /// <summary>
        /// 号源ID
        /// </summary>
        public string ResourceID { get; set; }
        /// <summary>
        /// 商户订单号
        /// </summary>
        public string OutTradeNo { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊
        /// </summary>
        public int AptType { get; set; }
        /// <summary>
        /// 微信支付订单号
        /// </summary>
        public string TradeNo { get; set; }
        /// <summary>
        /// 科室代码
        /// </summary>
        public string DeptCode { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public string DeptName { get; set; }
        /// <summary>
        /// 医生工号
        /// </summary>
        public string DoctorId { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }
        /// <summary>
        /// 挂号日期
        /// </summary>
        public string RegistDate { get; set; }
        /// <summary>
        /// 挂号时间段
        /// </summary>
        public string RegistTime { get; set; }
        /// <summary>
        /// 挂号金额
        /// </summary>
        public string Amount { get; set; }
        /// <summary>
        /// 病情描述
        /// </summary>
        public string Description { get; set; }
        /// <summary>
        /// 图片
        /// </summary>
        public string Image { get; set; }
        /// <summary>
        /// 诊断{“itemCode”:”FB32.5”,”itemName”:”肌肉拉伤或扭伤”}
        /// </summary>
        public string DiagnosisDetails { get; set; }
        /// <summary>
        /// 是否是保险用户
        /// </summary>
        public bool IsInsuranceUser { get; set; }

        public bool IsEnglish { get; set; }
    }



    public class ReVisitComfirm
    {
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

    }

    public class ReVisitReb
    {
        /// <summary>
        /// 是否成功
        /// </summary>
        public bool IsSuccess { get; set; }
        public string Message { get; set; }
        public string CardNo { get; set; }
        public string CardType { get; set; }

    }

    public class UpdateReVisitReq
    {
        /// <summary>
        /// 
        /// </summary>
        public string AccessToken { get; set; }
        public string OutTradeNo { get; set; }
        /// <summary>
        /// [3]已接诊, [5]已过号, [6]过号候诊, [98]已取消, [99]已完成, [100]已关闭, [101]已中止
        /// </summary>
        public int StatusDiv { get; set; }

    }

    public class UpdateReVisitReb
    {
        /// <summary>
        /// 
        /// </summary>
        public bool IsSuccess { get; set; }
        public string Message { get; set; }


    }

    public class DrugReq
    {
        public string AccessToken { get; set; }
    }
    public class DrugReb
    {
        public DrugReb()
        {
            Drug_List = new List<DrugList>();
        }
        public DrugResponseResult ResponseResult { get; set; }
        public List<DrugList> Drug_List { get; set; }
    }
    public class DrugResponseResult
    {
        public bool IsSuccess { get; set; }
        public string Message { get; set; }
    }
    public class DrugList
    {
        /// <summary>
        /// 药品名称
        /// </summary>
        public string DrugName { get; set; }
        /// <summary>
        /// 用药说明
        /// </summary>
        public string DrugUseMemo { get; set; }
        /// <summary>
        /// 剂型
        /// </summary>
        public string DosageForm { get; set; }
        /// <summary>
        /// 包装单位
        /// </summary>
        public string PackageUnit { get; set; }
        /// <summary>
        /// 用药途径
        /// </summary>
        public string Usage { get; set; }
        /// <summary>
        /// 用药频次
        /// </summary>
        public string Frequency { get; set; }
        /// <summary>
        /// 规格型号
        /// </summary>
        public string Specification { get; set; }
        public string UniqueCode { get; set; }
        /// <summary>
        /// 厂家名称
        /// </summary>
        public string ManufactorName { get; set; }
        /// <summary>
        /// 单价
        /// </summary>
        public string Price { get; set; }
        /// <summary>
        /// 单次剂量
        /// </summary>
        public string SingleDosage { get; set; }
        /// <summary>
        /// 剂量单位
        /// </summary>
        public string DosageUnit { get; set; }
        /// <summary>
        /// 药店名称
        /// </summary>
        public string DrugstoreName { get; set; }
        /// <summary>
        /// 状态
        /// </summary>
        public string Status { get; set; }
        /// <summary>
        /// 状态区分
        /// </summary>
        public string StatusDiv { get; set; }
        /// <summary>
        /// 图片
        /// </summary>
        public string Image { get; set; }
        /// <summary>
        /// 药品商品名
        /// </summary>
        public string TradeName { get; set; }
        /// <summary>
        /// 剂型代码
        /// </summary>
        public string DosageFormCode { get; set; }
        /// <summary>
        /// 配送药品类型
        /// </summary>
        public string DrugType { get; set; }
        /// <summary>
        /// 批准文号
        /// </summary>
        public string ApprovalNo { get; set; }
        /// <summary>
        /// 基药标识
        /// </summary>
        public string DrugFlag { get; set; }
        /// <summary>
        /// 抗生素标识
        /// </summary>
        public string AntibioticFlag { get; set; }
        /// <summary>
        /// 精麻毒放标识
        /// </summary>
        public string AnaesthesiaFlag { get; set; }
        /// <summary>
        /// 制剂标志
        /// </summary>
        public string PreparationSign { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public string DeptName { get; set; }
    }

    public class DrugDictionaryReq
    {
        public string AccessToken { get; set; }
        public string DrugCode { get; set; }
    }
    public class DrugDictionaryReb
    {
        public DrugDictionaryReb()
        {
            FrequencyList = new List<DrugDictionaryFrequencyList>();
        }
        public DrugDictionaryResponseResult ResponseResult { get; set; }
        public List<DrugDictionaryFrequencyList> FrequencyList { get; set; }
    }
    public class DrugDictionaryResponseResult
    {
        public bool IsSuccess { get; set; }
        public string Message { get; set; }
    }
    public class DrugDictionaryFrequencyList
    {
        public string ItemName { get; set; }
        public string ItemCode { get; set; }
    }

    public class PrescriptionOrderReq
    {
        public string AccessToken { get; set; }
        public string OpenUserID { get; set; }
        public string PatientId { get; set; }
        public string PrescriptionID { get; set; }
        public string ReceivingName { get; set; }
        public string HomeAddress { get; set; }
        public string HomeAddressDetail { get; set; }
        public string Tel { get; set; }
        public int DeliveryManner { get; set; }
        public string OutTradeNo { get; set; }
        public string TradeNo { get; set; }
        public decimal Amount { get; set; }
    }
    public class PrescriptionOrderReb
    {
        public bool IsSuccess { get; set; }
        public string Message { get; set; }
    }
}
