﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 退款接口参数
    /// </summary>
    public class LcTradeRefundParam
    {
        /// <summary>
        /// 平台分配给开发者的应用ID
        /// </summary>
        public string App_id { get; set; }
        /// <summary>
        /// 接口名称
        /// </summary>
        public string Method { get; set; }
        /// <summary>
        /// 发送请求的时间，格式'yyyy - MM - dd HH:mm:ss'
        /// </summary>
        public string Timestamp { get; set; }
        /// <summary>
        /// 请求随机字符串 每次请求值不能一样
        /// </summary>
        public string Nonce_str { get; set; }
      
        /// <summary>
        /// 业务参数
        /// </summary>
        public Biz_Content2 Biz_Content { get; set; }
        /// <summary>
        /// 商户生成签名字符串所使用的签名算法类型，目前支持RSA 
        /// </summary>
        public string Sign_type { get; set; }
        /// <summary>
        /// 商户请求参数的签名串
        /// </summary>
        public string Sign { get; set; }
    }
    /// <summary>
    /// 业务参数
    /// </summary>
    public class Biz_Content2
    {
        /// <summary>
        /// 微信或者支付宝交易流水号
        /// </summary>
        public string Trade_no { get; set; }
        /// <summary>
        /// 商户交易号 --原订单号
        /// </summary>
        public string Out_trade_no { get; set; }
        /// <summary>
        /// 订单金额。
        /// </summary>
        public decimal Trade_amount { get; set; }
        /// <summary>
        /// 需要退款的金额
        /// </summary>
        public decimal Refund_amount { get; set; }
        /// <summary>
        /// 支付方式alipay 或者 weixin 或者 unionpay 或者 eshimin
        /// </summary>
        public string Payment_type { get; set; }
        /// <summary>
        /// 标识一次退款请求，同一笔交易多次退款需要保证唯一，如需部分退款，则此参数必传。
        /// </summary>
        public string Out_request_no { get; set; }
        /// <summary>
        /// 退款原因
        /// </summary>
        public string Refund_reason { get; set; }
        /// <summary>
        /// 商户的操作员编号--APP(UserId)--ADMIN(UserId)
        /// </summary>
        public string Operator_id { get; set; }
        /// <summary>
        /// 商户机具终端编号
        /// </summary>
        public string Terminal_id { get; set; }

    }

    public class RefundInfo
    {
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 退款人ID
        /// </summary>
        public string UserId { get; set; }
        /// <summary>
        /// 退款原因
        /// </summary>
        public string RefundReason { get; set; }
        /// <summary>
        /// 商户机具终端编号
        /// </summary>

        public string TerminalId { get; set; }
    }

}
