﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 异步回调接口参数
    /// </summary>
    public class LcTradeNotifyParam
    {
        /// <summary>
        /// 平台分配给开发者的应用ID
        /// </summary>
        public string App_id { get; set; }
        /// <summary>
        /// 接口名称
        /// </summary>
        public string Method { get; set; }
        /// <summary>
        /// 发送请求的时间，格式'yyyy - MM - dd HH:mm:ss'
        /// </summary>
        public string Timestamp { get; set; }
        /// <summary>
        /// 签名算法类型，目前支持RSA
        /// </summary>
        public string Sign_type { get; set; }
        /// <summary>
        /// 商户请求参数的签名串，详见
        /// </summary>
        public string Sign { get; set; }
      
        /// <summary>
        /// 业务参数
        /// </summary>
        public Biz_Content1 Biz_Content { get; set; }
        /// <summary>
        /// 支付宝微信异步通知原始数据 
        /// </summary>
        public string Response_content { get; set; }
    }
    /// <summary>
    /// 业务参数
    /// </summary>
    public class Biz_Content1 
    {
        /// <summary>
        /// 平台交易凭证号
        /// </summary>
        public string Trade_no { get; set; }
        /// <summary>
        /// 原支付请求的商户订单号
        /// </summary>
        public string Out_trade_no { get; set; }
        /// <summary>
        /// 买家平台账号对应的平台唯一用户号。
        /// </summary>
        public string User_id { get; set; }
        /// <summary>
        /// 交易目前所处的状态
        /// </summary>
        public string Trade_status { get; set; }
        /// <summary>
        /// 本次交易支付的订单金额，单位为人民币（元）
        /// </summary>
        public decimal Total_amount { get; set; }
        /// <summary>
        /// 该笔交易的买家付款时间。格式为yyyy-MM-dd HH:mm:ss
        /// </summary>
        public string Gmt_payment { get; set; }
        /// <summary>
        /// 标识支付类型，此字段需要额外申请
        /// </summary>
        public string Payment_type { get; set; }
        


    }

    public class AppPayResponse
    {
        /// <summary>
        /// 编码
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 消息
        /// </summary>
        public string Msg { get; set; }
        /// <summary>
        /// 平台交易凭证号
        /// </summary>
        public string Trade_no { get; set; }
        /// <summary>
        /// 原支付请求的商户订单号
        /// </summary>
        public string Out_trade_no { get; set; }
        /// <summary>
        /// 本次交易支付的订单金额，单位为人民币（元）
        /// </summary>
        public decimal Total_amount { get; set; }
        /// <summary>
        /// 该笔交易的买家付款时间。格式为yyyy-MM-dd HH:mm:ss
        /// </summary>
        public string TimeStamp { get; set; }
    }


}
