﻿using ASHermed.SinoInterface.Api.ContractModel.App.Entity;
using ASHermed.SinoInterface.Api.ContractModel.App.Model;
using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class OrderModel
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }

        /// <summary>
        /// 患者Id
        /// </summary>
        public int PatId { get; set; }
        public int AptId { get; set; }

        /// <summary>
        /// 医生id
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 科室ID
        /// </summary>
        public int DeptId { get; set; }

        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? AptTime { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊
        /// </summary>
        public int AptType { get; set; }
        /// <summary>
        /// 是否使用优惠券
        /// </summary>
        public bool IsUseCoupon { get; set; }
        /// <summary>
        /// 优惠券id 因为存在多券组合支付，所以用半圆角,区分
        /// </summary>
        public string CouponId { get; set; }

        /// <summary>
        /// 是否是保险用户
        /// </summary>
        public bool IsInsuranceUser { get; set; }
        /// <summary>
        /// 保险信息
        /// </summary>
        public int InsuranceId { get; set; }
        /// <summary>
        /// 保险状态(1保险待审核,2保险,3保险失效)
        /// </summary>
        public int InsuranceStatus { get; set; }

        /// <summary>
        /// 备注信息
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 语言
        /// </summary>
        public int Language { get; set; }
        /// <summary>
        /// 支付类型(alipay,weixin,unionpay)
        /// </summary>
        public string PayWay { get; set; }
    }


    public class OrderPayModel
    {
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }

        /// <summary>
        /// 订单状态(1待付款,2已付款 待确认,3已付款 已确认,4已付款 已完成就诊,5订单取消,6 订单退款成功,7 订单退款失败, 8 订单退款中)
        /// </summary>
        public int OrderStatus { get; set; }

        /// <summary>
        /// 支付类型(alipay,weixin,unionpay)
        /// </summary>
        public string PayWay { get; set; }

        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? PayTime { get; set; }
    }

    public class OrderListModel
    {
        public string OrderNo { get; set; }
        public int AptType { get; set; }
        public int AptId { get; set; }
        public decimal Price { get; set; }
        public int OrderStatus { get; set; }
        public DateTime CreateTime { get; set; }
        public bool IsInsuranceUser { get; set; }
    }
    public class OrderDetailModel
    {
        public string OrderNo { get; set; }
        /// <summary>
        /// 患者Id
        /// </summary>
        public int PatId { get; set; }
        public string PatName { get; set; }
        public string Pid { get; set; }
        /// <summary>
        /// 订单状态(1待付款,2已付款 待确认,3已付款 已确认,4已付款 已完成就诊,5订单取消,6 订单退款成功,7 订单退款失败, 8 订单退款中, 9保险待审核,10保险已审核,11保险已完成,20保险代签字)
        /// </summary>
        public int OrderStatus { get; set; }
        public int Status { get; set; }
        /// <summary>
        /// 医生id
        /// </summary>
        public int DocId { get; set; }
        public string DocName { get; set; }
        /// <summary>
        /// 预约金额
        /// </summary>
        public decimal AptPrice { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? AptTime { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊3处方
        /// </summary>
        public int AptType { get; set; }
        public int AptId { get; set; }
        /// <summary>
        /// 是否使用优惠券
        /// </summary>
        public bool IsUseCoupon { get; set; }
        /// <summary>
        /// 优惠券id
        /// </summary>
        public int CouponId { get; set; }
        /// <summary>
        /// 优惠券金额
        /// </summary>
        public decimal CouponPrice { get; set; }
        /// <summary>
        /// 是否是保险用户
        /// </summary>
        public bool IsInsuranceUser { get; set; }
        /// <summary>
        /// 保险信息
        /// </summary>
        public int InsuranceId { get; set; }
        /// <summary>
        /// 保险状态(1保险待审核,2保险,3保险失效)
        /// </summary>
        public int InsuranceStatus { get; set; }
        /// <summary>
        /// 订单金额(实付)
        /// </summary>
        public decimal PayPrice { get; set; }

        public DateTime CreateTime { get; set; }
        public string DeptName { get; set; }
        public string ListImage { get; set; }
        public string Description { get; set; }
        public string Notice { get; set; }
        public string PayWay { get; set; }
        public DateTime? PayTime { get; set; }
        public string RefundPayWay { get; set; }
        public DateTime? RefundPayTime { get; set; }
        public int CommentId { get; set; }
        public string GroupId { get; set; }
        public string HelperImId { get; set; }
        public MyPrescriptionList PrescriptionInfo { get; set; }
        public Online_Order_Comment CommentInfo { get; set; }
        public int LinKingAptStatus { get; set; }
        /// <summary>
        /// 保险信息
        /// </summary>
        public InsuranceModel InsuranceInfo { get; set; }
        public int ApplyUserId { get; set; }
    }


    public class CancelOrderReq
    {
        public string OrderNo { get; set; }

    }

    public class OverOrderReq
    {
        public string OrderNo { get; set; }

    }

    public class OrderCommentReq
    {

        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 医生id
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 星数12345
        /// </summary>
        public double Star { get; set; }
        /// <summary>
        /// 评价
        /// </summary>
        public string Comment { get; set; }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId { get; set; }
        /// <summary>
        /// 评价人姓名
        /// </summary>
        public string CreateUser { get; set; }

        /// <summary>
        /// 是否匿名
        /// </summary>
        public bool IsAnonymous { get; set; }

    }


    public class InsuranceOrderSignReq
    {
        public string OrderNo { get; set; }
        /// <summary>
        /// 签名图片地址
        /// </summary>
        public string InsuranceSign { get; set; }
        public int AddressId { get; set; }
    }

    public class ResOrder
    {
        public string OrderNo { get; set; }
        /// <summary>
        /// jiage
        /// </summary>
        public decimal Price { get; set; }
    }
}
