﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 订单
    /// </summary>
    public class Online_Order
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 预约码
        /// </summary> 
        public int AptId { get; set; }
        /// <summary>
        /// 患者Id
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 订单状态(1待付款,2已付款 待确认,3已付款 已确认,4已付款 已完成就诊,5订单取消,6 订单退款成功,7 订单退款失败, 8 订单退款中, 9保险待审核,10保险已审核,11保险已完成,12保险通过,13药房审核,14保险理赔审核,17医生审核,20保险代签字)
        /// </summary>
        public int OrderStatus { get; set; }
        /// <summary>
        /// 订单时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 医生id
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 预约金额
        /// </summary>
        public decimal AptPrice { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? AptTime { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊3处方
        /// </summary>
        public int AptType { get; set; }
        /// <summary>
        /// 是否使用优惠券
        /// </summary>
        public bool IsUseCoupon { get; set; }
        /// <summary>
        /// 优惠券id
        /// </summary>
        public int CouponId { get; set; }
        /// <summary>
        /// 优惠券金额
        /// </summary>
        public decimal CouponPrice { get; set; }
        /// <summary>
        /// 是否是保险用户
        /// </summary>
        public bool IsInsuranceUser { get; set; }
        /// <summary>
        /// 保险信息
        /// </summary>
        public int InsuranceId { get; set; }
        /// <summary>
        /// 保险状态(1cigna)
        /// </summary>
        public int InsuranceStatus { get; set; }
        /// <summary>
        /// 保险签名
        /// </summary>
        public string InsuranceSign { get; set; }
        /// <summary>
        /// 订单金额(实付)
        /// </summary>
        public decimal PayPrice { get; set; }
        /// <summary>
        /// 支付类型(alipay,weixin,unionpay)
        /// </summary>
        public string PayWay { get; set; }
        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? PayTime { get; set; }
        /// <summary>
        /// 支付流水号
        /// </summary>
        public string TradeNo { get; set; }
        
        /// <summary>
        /// 备注信息
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public string UpdateUser { get; set; }
        /// <summary>
        /// 是否是英文订单
        /// </summary>
        public bool IsEnglish{ get; set; }
}
}
