﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 添加预约入参
    /// </summary>
    public class OnlineAptParam
    {
        public OnlineAptParam()
        {
            IsDeleted = false;
        }
        /// <summary>
        /// 主键
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// his的预约id
        /// </summary>
        public string EpisodeId { get; set; }
        /// <summary>
        /// 患者的id
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 医院id
        /// </summary>
        public int HosId { get; set; }
        /// <summary>
        /// 科室id
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// 医生
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? AptTime { get; set; }
        /// <summary>
        /// 预约类型(1视频预约,2复诊开药)
        /// </summary>
        public int AptType { get; set; }
        /// <summary>
        /// 服务项目id
        /// </summary>
        public int AptProj { get; set; }
        /// <summary>
        /// 预约操作状态(1待确认,2已确认,3已取消,4已付款(对应我的预约即将就诊),5已完成)
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 预约保险确认状态(0未使用,1=待确认/2=取消/4=已确认)
        /// </summary>
        public int InnerStatus { get; set; }
        /// <summary>
        /// 客服最后一次处理时间
        /// </summary>
        public DateTime? DisposeTime { get; set; }
        /// <summary>
        /// 预约号源
        /// </summary>
        public string AptUsrn { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 申请人userid
        /// </summary>
        public int ApplyUserId { get; set; }
        /// <summary>
        /// 预约来源（1=平台/2=his/4=快速预约（web官网）/8=快速预约（微信官网）/16=快速预约（患者版）/32=中文/64=英文/128=特色门诊预约/256=疫苗预约/512=视频预约）
        /// </summary>
        public int SourceType { get; set; }
        /// <summary>
        /// APP预约唯一匹配码
        /// </summary>
        public string MatchCode { get; set; }
        /// <summary>
        /// 付款类型(0未付款,1已付款,2退款)
        /// </summary>
        public int PayStatus { get; set; }
        /// <summary>
        /// 付款金额
        /// </summary>
        public decimal PayPrice { get; set; }
        /// <summary>
        /// 病情描述
        /// </summary>
        public string Description { get; set; }
        /// <summary>
        /// 病情图片(可能会有多张  用  ' | '分割)
        /// </summary>
        public string DescImage { get; set; }
        public DateTime CreateTime { get; set; }
        public DateTime UpdateTime { get; set; }

        public bool IsDeleted { get; set; }

    }
}
