﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 互联网医院处方主表 实体 
    /// </summary>
    public class Out_Internet_Prescription_Info
    {
        /// <summary>
        /// 主键
        /// </summary>
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 患者ID
        /// </summary>
        public string PID { get; set; }
        /// <summary>
        /// 预约号
        /// </summary>
        public string Appt_Number { get; set; }
        /// <summary>
        /// 处方号
        /// </summary>
        public string Prescription_No { get; set; }
        /// <summary>
        /// 开方时间
        /// </summary>
        public DateTime? Prescription_Date { get; set; }
        /// <summary>
        /// 患者姓名
        /// </summary>
        public string Patient_Name { get; set; }
        /// <summary>
        /// 患者性别
        /// </summary>
        public string Patient_Sex { get; set; }
        /// <summary>
        /// 患者年龄
        /// </summary>
        public int Patient_Age { get; set; }
        /// <summary>
        /// 患者生日
        /// </summary>
        public string Patient_Birthday { get; set; }
        /// <summary>
        /// 费别0=自费/1=保
        /// </summary>
        public int Fee_Zype { get; set; }
        /// <summary>
        /// 患者手机号
        /// </summary>
        public string Patient_Tel { get; set; }
        /// <summary>
        /// 医保卡号
        /// </summary>
        public string Patient_Cardno { get; set; }
        /// <summary>
        /// 科室名称
        /// </summary>
        public string Dept_Name { get; set; }
        /// <summary>
        /// 诊断
        /// </summary>
        public string Diagnosis { get; set; }
        /// <summary>
        /// 诊断说明
        /// </summary>
        public string Diagnosticlnstructions_Detailr { get; set; }
        /// <summary>
        /// 过敏信息
        /// </summary>
        public string AllergyHistory { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string Doc_Name { get; set; }
        /// <summary>
        /// 审方名
        /// </summary>
        public string Auditor_Name { get; set; }
        /// <summary>
        /// 收货人姓名
        /// </summary>
        public string Receipt_Name { get; set; }
        /// <summary>
        /// 收货人手机号
        /// </summary>
        public string Receipt_Phone { get; set; }
        /// <summary>
        /// 收货人地址
        /// </summary>
        public string Receipt_Address { get; set; }
        /// <summary>
        /// 备注信息
        /// </summary>
        public string Receipt_Remark { get; set; }
        /// <summary>
        /// 处方状态 -4 退款失败, -3 退款成功 ,-2 退款中 ,-1 订单已取消, 0 未付款, 1=待处理/2=已发货/3=待发货/1024=已签收
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 审核状态(0待审核  1审核通过, 2审核不通过)
        /// </summary>
        public int Audit_Status { get; set; }
        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal Total_Amount { get; set; }

      
    }
}
