﻿using ASHermed.SinoInterface.Api.ContractModel.App.Entity;
using ASHermed.SinoInterface.Api.ContractModel.App.Model;
using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 处方单
    /// </summary>
    public class PrescriptionReq
    {
        public int PatId { get; set; }
        /// <summary>
        /// 患者ID
        /// </summary>
        public string PID { get; set; }
        /// <summary>
        /// 预约号
        /// </summary>
        public string OutRecordNo { get; set; }
        /// <summary>
        /// 处方号
        /// </summary>
        public string PrescriptionNo { get; set; }
        /// <summary>
        /// 开方时间
        /// </summary>
        public DateTime? PrescriptionDate { get; set; }
        /// <summary>
        /// 患者姓名
        /// </summary>
        public string PatientName { get; set; }
        /// <summary>
        /// 患者性别
        /// </summary>
        public string PatientSex { get; set; }
        /// <summary>
        /// 患者生日
        /// </summary>
        public string PatientBirthday { get; set; }
        /// <summary>
        /// 患者年龄
        /// </summary>
        public string PatientAge { get; set; }
        /// <summary>
        /// 费别0=自费/1=保
        /// </summary>
        public int FeeType { get; set; }
        /// <summary>
        /// 患者手机号
        /// </summary>
        public string PatientTel { get; set; }
        /// <summary>
        /// 用户ID
        /// </summary>
        public string PatientCardno { get; set; }
        public string DeptName { get; set; }
        public string DocName { get; set; }
        /// <summary>
        /// 审方名
        /// </summary>
        public string AuditorName { get; set; }
        public string ReceiptName { get; set; }
        public string ReceiptPhone { get; set; }
        public string ReceiptAddrss { get; set; }
        public string ReceiptRemark { get; set; }
        public string Diagnosis { get; set; }
        public List<DiagnosticInstructionsDetailItem> DiagnosticInstructionsDetail { get; set; }
        public string DiagnosticInstructionsDetailStr { get; set; }
        /// <summary>
        /// 过敏信息
        /// </summary>
        public string DrugAllergyHistory { get; set; }
        public string AllergyHistory { get; set; }
        /// <summary>
        /// 支付金额
        /// </summary>
        public decimal TotalAmount { get; set; }

        public List<Drugs> DrugList { get; set; }
        public string Remark { get; set; }

    }

    public class DiagnosticInstructionsDetailItem
    {
        public string Code { get; set; }
        public string Name { get; set; }
        public string Result { get; set; }
    }
    public class Drugs
    {
        public string DrugName { get; set; }
        public string DrugSpec { get; set; }
        public decimal Cnt { get; set; }
        public string PackageUnit { get; set; }
        public string UseInfo { get; set; }
        public string Frequency { get; set; }
        public decimal UseDaySize { get; set; }
        public string UseDaySizeUnit { get; set; }
        public decimal SingleDosage { get; set; }
        public string DosageUnit { get; set; }
        public string Usage { get; set; }
        public string PrescriptionNo { get; set; }
        public string UniqueCode { get; set; }
        public string PackageUnitCode { get; set; }
        public string FrequencyCode { get; set; }
        public string DosageUnitCode { get; set; }
        public string UsageCode { get; set; }
        public string Remark { get; set; }

    }
    public class DrugsInfo : Drugs
    {
        public string PrescriptionNo { get; set; }
    }

    public class LinKingIMRequest
    {
        public string OutTradeNo { get; set; }
        public List<LinKingIMDetail> Content { get; set; }

    }
    public class LinKingIMDetail
    {
        public bool IsDoctor { get; set; }
        public string MessageType { get; set; }
        public string TalkContent { get; set; }
        public string TalkName { get; set; }
        public DateTime TalkTime { get; set; }
    }

    public class VaccineApptRequest
    {
        public int[] PatIds { get; set; }
        public int Origin { get; set; }
        public string Remake { get; set; }
    }
    public class ConfirmCallRequest
    {
        public List<VaccineApptForUser> User { get; set; }
        public int CallId { get; set; }
        public Out_Vaccine_Appt_Call Model { get; set; }
    }

}
