﻿namespace ASHermed.SinoInterface.Api.ContractModel.Param
{
    /// <summary>
    /// 订单支付成功推送
    /// </summary> 
    public class TradePaidParam
    {
        /// <summary>
        /// client_id
        /// </summary>
        public string client_id { get; set; }

        /// <summary>
        /// 业务消息的标识，交易订单号的值
        /// </summary>
        public string id { get; set; }

        /// <summary>
        /// 店铺ID
        /// </summary>
        public long? kdt_id { get; set; }

        /// <summary>
        /// 店铺名称
        /// </summary>
        public string kdt_name { get; set; }

        /// <summary>
        /// 经过UrlEncode(UTF-8)编码,需要解码
        /// </summary>
        public string msg { get; set; }

        /// <summary>
        /// 消息唯一标示
        /// </summary>
        public string msg_id { get; set; }

        /// <summary>
        /// 连锁总店ID
        /// </summary>
        public long? root_kdt_id { get; set; }

        /// <summary>
        /// 重发的次数，最多重推4次，每次推送间隔为5s, 5m20s, 21m20s, 2h
        /// </summary>
        public int? sendCount { get; set; }

        /// <summary>
        /// 防伪签名: MD5(client_id+msg+client_secrect)。不建议使用此字段，可以用请求头中的Event-Sign进行防伪验证
        /// </summary>
        public string sign { get; set; }

        /// <summary>
        /// 订单状态，TRADE_SUCCESS-交易成功
        /// </summary>
        public string status { get; set; }

        /// <summary>
        /// 消息业务类型，trade_TradeSuccess-交易成功
        /// </summary>
        public string type { get; set; }

        /// <summary>
        /// 消息版本号,为了解决顺序性的问题,高版本覆盖低版本
        /// </summary>
        public long? version { get; set; }
    }
}