﻿using ASHermed.SinoInterface.Api.ContractModel.Shared;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.Login
{
    /// <summary>
	/// 通过手机号码和验证码进行单点登录[参数]
	/// 创建人：杨江军
	/// 创建时间：2020/4/8 16:38:04
	/// </summary>
	public class SingleSignOnByPhonesParam : BaseClientParam
    {
        /// <summary>
        /// 手机号码
        /// </summary>
        [Required(ErrorMessage = "[手机号码]不能为空")]
        [StringLength(maximumLength: 11, MinimumLength = 11, ErrorMessage = "[手机号码]无效")]
        public string Phone { get; set; }

        /// <summary>
        /// 验证码
        /// </summary>
        [Required(ErrorMessage = "[验证码]不能为空")]
        [StringLength(maximumLength: 4, MinimumLength = 4, ErrorMessage = "[验证码]无效")]
        public string VerifyCode { get; set; }

        /// <summary>
        /// 是否启用独占式登录（如果选择启用会把其他已经登录的客户端挤下线，如果选择不启用则发现有其它客户端在线则会返回消息提醒）
        /// </summary>
        [Required(ErrorMessage = "[是否启用独占式登录]不能为空")]
        public bool IsExclusiveLogin { get; set; }
    }
}
