﻿using ASHermed.SinoInterface.Api.ContractModel.Shared;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.Login
{
    /// <summary>
	/// 通过登录名和密码进行单点登录[参数]
	/// 创建人：杨江军
	/// 创建时间：2020/3/26 13:50:14
	/// </summary>
	public class SingleSignOnByLoginIdParam : BaseClientParam
    {
        /// <summary>
        /// 登录名
        /// </summary>
        [Required(ErrorMessage = "[登录名]不能为空")]
        public string LoginId { get; set; }

        /// <summary>
        /// 登录密码
        /// </summary>
        [Required(ErrorMessage = "[登录密码]不能为空")]
        public string LoginPwd { get; set; }

        /// <summary>
        /// 是否启用独占式登录（如果选择启用会把其他已经登录的客户端挤下线，如果选择不启用则发现有其它客户端在线则会返回消息提醒）
        /// </summary>
        [Required(ErrorMessage = "[是否启用独占式登录]不能为空")]
        public bool IsExclusiveLogin { get; set; }
    }
}
