﻿using ASHermed.SinoInterface.Api.ContractModel.Shared;
using ASHermed.SinoInterface.Enum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.Login
{
    /// <summary>
	/// 发送短信验证码[参数]
	/// 创建人：杨江军
	/// 创建时间：2020/4/8 16:34:20
	/// </summary>
	public class SendSMSVerifyCodeParam : BaseClientParam
    {
        /// <summary>
        /// 手机号码
        /// </summary>
        [Required(ErrorMessage = "[手机号码]不能为空")]
        public string Phone { get; set; }

        /// <summary>
        /// 验证码类型 1：短信验证码 2：语音播报验证码
        /// </summary>
        [Required(ErrorMessage = "[验证码类型]不能为空")]
        [Range(1, 2, ErrorMessage = "[验证码类型]错误")]
        public VerifyCodeType VerifyCodeType { get; set; }
    }
}
