﻿using ASHermed.SinoInterface.Enum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.Login
{
    /// <summary>
    /// 用户手机号码
    /// </summary>
    public class UserPhoneEntity
    {
        /// <summary>
        /// 手机号码
        /// </summary>
        [Required(ErrorMessage = "[手机号码]不能为空")]
        public string Phone { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        [Required(ErrorMessage = "[手机号码状态]不能为空")]
        [Range(1, 3, ErrorMessage = "[手机号码状态]错误，只能选择枚举范围内大于0的值！")]
        public DataStateType DataState { get; set; }
    }
}
