﻿using ASHermed.SinoInterface.Enum;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.Login
{
    /// <summary>
    /// 系统信息[实体]
    /// 创建人：杨江军
    /// 创建时间：2020/3/25 18:25:39
    /// </summary>
    public class SystemInfoEntity
    {
        /// <summary>
        /// 系统ID
        /// </summary>
        public long ID { get; set; }

        /// <summary>
        /// 系统别名
        /// </summary>
        public string AliasName { get; set; }

        /// <summary>
        /// 系统名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 短信配置
        /// </summary>
        public List<SMSConfigEntity> SMSConfigs { get; set; }

        /// <summary>
        /// Right系统的系统ID 
        /// </summary>
        public string RightSystemId { get; set; }

        /// <summary>
        /// 创建人Id（批量新增或修改时无需传入）
        /// </summary>
        public long CreaterId { get; set; }

        /// <summary>
        /// 创建人姓名（批量新增或修改时无需传入）
        /// </summary>
        public string CreaterName { get; set; }

        /// <summary>
        /// 创建时间（批量新增或修改时无需传入）
        /// </summary>
        public DateTime CreaterTime { get; set; }

        /// <summary>
        /// 修改人Id（批量新增或修改时无需传入）
        /// </summary>
        public long ModifierId { get; set; }

        /// <summary>
        /// 修改人姓名（批量新增或修改时无需传入）
        /// </summary>
        public string ModifierName { get; set; }

        /// <summary>
        /// 修改时间（批量新增或修改时无需传入）
        /// </summary>
        public DateTime ModifierTime { get; set; }

        /// <summary>
        /// 数据状态
        /// </summary>
        public DataStateType DataState { get; set; }

        /// <summary>
        /// 默认构造函数
        /// </summary>
        public SystemInfoEntity()
        {
            SMSConfigs = new List<SMSConfigEntity>();
        }
    }

    /// <summary>
    /// 短信配置
    /// </summary>
    public class SMSConfigEntity
    {
        /// <summary>
        /// 短信签名(短信内容的前缀，需要在阿里注册过的)
        /// </summary>
        public string Sign { get; set; }

        /// <summary>
        /// 模板代码
        /// </summary>
        public string TemplateCode { get; set; }

        /// <summary>
        /// 短信类型 1：文本短信 2：语音播报
        /// </summary>
        public VerifyCodeType Type { get; set; }
    }
}
