﻿using ASHermed.FileManage.Enum.Image;
using Microsoft.AspNetCore.Http;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ASHermed.SinoInterface.Api.ContractModel.Framework.File
{
    /// <summary>
    /// 文件上传(客户端封装版)[参数]
    /// 创建人：杨江军
    /// 创建时间：2021/1/11/星期一 15:30:25
    /// </summary>
    public class UploadFileForForClientParam
    {
        /// <summary>
        /// 文件
        /// </summary>
        [Required(ErrorMessage = "[上传文件]不能为空")]
        public IFormFile File { get; set; }

        /// <summary>
        /// 图片缩放枚举
        /// </summary>
        public PictureZoomEnum ReSize { get; set; }

        /// <summary>
        /// 缩略图的高[如果使用缩略图模式则必填]
        /// </summary>
        public int Height { get; set; }

        /// <summary>
        /// 缩略图的宽[如果使用缩略图模式则必填]
        /// </summary>
        public int Width { get; set; }

        /// <summary>
        /// 旋转度数
        /// </summary>
        public int Rotate { get; set; }

        /// <summary>
        /// 是否为受保护的文件
        /// </summary>
        [Required(ErrorMessage = "[是否为受保护的文件]不能为空")]
        public bool IsPrivate { get; set; } = true;

        /// <summary>
        /// 系统ID（除非必要无需赋值，会自动取配置文件中的配置）
        /// </summary>
        public long SystemId { get; set; } = 0;

        /// <summary>
        /// 系统名称（除非必要无需赋值，会自动取配置文件中的配置）
        /// </summary>
        public string SystemName { get; set; } = null;
    }
}
