﻿using System;
using System.Collections.Generic;
using System.Text;
using static ASHermed.SinoInterface.Tools.ExcelHelp;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class SurveyModel
    {
        public string Name { get; set; }
        public int Amount { get; set; }
    }

    public class SurveyData : IExcelModel
    {
        /// <summary>
        /// 诊所
        /// </summary>
        [ExcelAttibute("诊所")]
        public string Name { get; set; }
        /// <summary>
        /// 短信数量
        /// </summary>
        [ExcelAttibute("短信数量")]
        public int MsgAmount { get; set; }
        /// <summary>
        /// 回复数量
        /// </summary>
        [ExcelAttibute("回复数量")]
        public int ReplyAmount { get; set; }
        /// <summary>
        /// 回复率
        /// </summary>
        [ExcelAttibute("回复率")]
        public string ReplyRate { get; set; }
    }

    public class DataApt : IExcelModel
    {
        /// <summary>
        /// 科室
        /// </summary>
        [ExcelAttibute("科室")]
        public string Name { get; set; }
        /// <summary>
        /// 预约百分比
        /// </summary>
        [ExcelAttibute("预约百分比")]
        public string AptRate { get; set; }
        
        /// <summary>
        /// 取消百分比
        /// </summary>
        [ExcelAttibute("取消百分比")]
        public string CancelRate { get; set; }
    }

    public class DataPatAptMore : IExcelModel
    {
        /// <summary>
        /// 科室
        /// </summary>
        [ExcelAttibute("科室")]
        public string Name { get; set; }
        /// <summary>
        /// 半年内预约两次以上人数
        /// </summary>
        [ExcelAttibute("半年内预约两次以上人数")]
        public int PatCount { get; set; }

    }

    public class DataBtwAptCount : IExcelModel
    {
        /// <summary>
        /// 预约提交时间段
        /// </summary>
        [ExcelAttibute("预约提交时间段")]
        public string TimeBtw { get; set; }
        /// <summary>
        /// 预约数
        /// </summary>
        [ExcelAttibute("预约数")]
        public int AptCount { get; set; }

    }

    public class UserAgeCount : IExcelModel
    {
        /// <summary>
        /// 预约提交时间段
        /// </summary>
        [ExcelAttibute("年龄段")]
        public string AgeBtw { get; set; }
        /// <summary>
        /// 预约数
        /// </summary>
        [ExcelAttibute("人数")]
        public int UserCount { get; set; }

    }

    public class MyUser
    {
        public int Id { get; set; }
        public int Age { get; set; }
        public int Gender { get; set; }
    }
}
