﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Coupon.Model
{
    public class UserCouponView
    {
        public int Id { get; set; }
        /// <summary>
        /// App用户ID，优惠券发送到用户身上
        /// </summary>
        public int PubUserId { get; set; }
        /// <summary>
        /// 患者ID
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 优惠券id
        /// </summary>
        public int CouponId { get; set; }
        /// <summary>
        /// 优惠券金额
        /// </summary>
        public decimal Money { get; set; }
        /// <summary>
        /// 满减金额
        /// </summary>
        public decimal FullMoney { get; set; }
        /// <summary>
        /// 1为已使用，0为已领取未使用
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 优惠券名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 1满减券 2叠加满减券 3无门槛券（需要限制大小）4折扣券 5免费券
        /// </summary>
        public int Type { get; set; }
        /// <summary>
        /// 优惠券开始时间
        /// </summary>
        public DateTime StartTime { get; set; }
        /// <summary>
        /// 优惠券结束时间
        /// </summary>
        public DateTime EndTime { get; set; }
        /// <summary>
        /// 优惠券能使用的医生ID集合 空为任何医生可用
        /// </summary>
        public string DocIds { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊3处方
        /// </summary>
        public string AptType { get; set; }
        //优惠券领取时间
        public DateTime CreateTime { get; set; }

        public int EffectiveTime { get; set; }
        public string DeptId { get; set; }
        public bool IsDelete { get; set; }
        public DateTime EffectiveDateTime { get; set; }
    }
}
