﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.Coupon.Entity
{
    public class Online_Coupon
    {

        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 1满减券 2叠加满减券 3无门槛券（需要限制大小）4折扣券 5免费券
        /// </summary>
        public int Type { get; set; }
        /// <summary>
        /// 优惠券名称
        /// </summary>
        public string Name { get; set; }
        /// <summary>
        /// 优惠券名称EN
        /// </summary>
        public string NameEN { get; set; }
        /// <summary>
        /// 图片的URL地址
        /// </summary>
        public string Img { get; set; }
        /// <summary>
        /// 优惠券开始时间
        /// </summary>
        public DateTime StartTime { get; set; }
        /// <summary>
        /// 优惠券结束时间
        /// </summary>
        public DateTime EndTime { get; set; }
        /// <summary>
        /// 优惠券金额，用整数，固定值目前。
        /// </summary>
        public decimal Money { get; set; }
        /// <summary>
        /// 状态，1生效 2失效
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 优惠券的说明
        /// </summary>
        public string Remarks { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 金额满
        /// </summary>
        public decimal FullMoney { get; set; }
        /// <summary>
        /// 优惠券能使用的医生ID集合 空为任何医生可用
        /// </summary>
        public string DocIds { get; set; }
        /// <summary>
        /// 配额：发券数量
        /// </summary>
        public int Quota { get; set; }
        /// <summary>
        /// 预约类型1视频2复诊3处方
        /// </summary>
        public string AptType { get; set; }
        /// <summary>
        /// 领券后的有效使用时间
        /// </summary>
        public int EffectiveTime { get; set; }
        /// <summary>
        /// 科室ID集合
        /// </summary>
        public string DeptId { get; set; }
        public bool IsDelete { get; set; }
        /// <summary>
        /// 详情说明
        /// </summary>
        public string Content { get; set; }
        /// <summary>
        /// 详情说明英文
        /// </summary>
        public string ContentEN { get; set; }
        /// <summary>
        /// 优惠券的说明 英文
        /// </summary>
        public string RemarksEN { get; set; }
        /// <summary>
        /// 面额描述
        /// </summary>
        public string MoneyRemark { get; set; }
        /// <summary>
        /// 面额描述英文
        /// </summary>
        public string MoneyRemarkEN { get; set; }
        /// <summary>
        /// 有效期描述
        /// </summary>
        public string TermOfValidity { get; set; }
        /// <summary>
        /// 有效期描述英文
        /// </summary>
        public string TermOfValidityEN { get; set; }
        /// <summary>
        /// 跳转链接
        /// </summary>
        public string HerfUrl { get; set; }
        public string CreateUser { get; set; }
        public string UpdateUser { get; set; }
        public DateTime UpdateTime { get; set; }
        public string MoneyRemarkUnit { get; set; }
        public string MoneyRemarkENUnit { get; set; }
        public DateTime EffectiveDateTime { get; set; }
        public string ImgEN { get; set; }
        public string CouponUrl { get; set; }
        public int LimitDay { get; set; }
        public int LimitCount { get; set; }
    }
}
