﻿namespace ASHermed.SinoInterface.Api.ContractModel.App.RequestForm
{
    /// <summary>
    /// 完善信息
    /// </summary>
    public class PerfectInfoParam
    {
        /// <summary>
        /// 患者id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 国籍
        /// </summary>
        public int NationalityId { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// 城市id
        /// </summary>
        public int CityId { get; set; }

        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }

        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }

        /// <summary>
        /// 区
        /// </summary>
        public string District { get; set; }

        /// <summary>
        /// 详细地址 
        /// </summary>
        public string LocalAddress { get; set; }

        /// <summary>
        /// 紧急联系人
        /// </summary>
        public string EmergencyName { get; set; }

        /// <summary>
        /// 紧急联系号码
        /// </summary>
        public string EmergencyPhone { get; set; }

        /// <summary>
        /// 紧急联系关系(pub_relationship主键)
        /// </summary>
        public int EmergencyRelation { get; set; }

        ///// <summary>
        ///// 如何了解(pubhowknow主键)
        ///// </summary>
        //public int HowKnow { get; set; }

        /// <summary>
        /// 随访方式(pubcontactway主键)
        /// </summary>
        public int ContactWay { get; set; }

        /// <summary>
        /// 随访方式的联系值
        /// </summary>
        public string Chat { get; set; }

        /// <summary>
        /// 支付类型(1自费,2保险)
        /// </summary>
        public int PayType { get; set; }
        /// <summary>
        /// 保险照片
        /// </summary>
        public string InsuranceCardUrl { get; set; }
    }
}