﻿using ASHermed.SinoInterface.Tools;

namespace ASHermed.SinoInterface.Api.ContractModel.App.RequestForm
{
    /// <summary>
    /// 绑定老患者参数
    /// </summary>
    public class BindOldPatientParam
    {
        /// <summary>
        /// PID
        /// </summary>
        public string PId { get; set; }

        /// <summary>
        /// tc患者主键
        /// </summary>
        public string TcRowId { get; set; }

        /// <summary>
        /// tc MRN
        /// </summary>
        public string Mrn { get; set; }

        /// <summary>
        /// 家庭关系
        /// 1-本人；2-父母；3-配偶；4-子女；5-朋友；6-其他
        /// </summary>
        public int FamilyTies { get; set; }

        /// <summary>
        /// 证件类型1身份证2护照3香港4澳门5其他
        /// </summary>
        public int CardType { get; set; }

        /// <summary>
        /// 证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CardId { get; set; }

        /// <summary>
        /// 证件有效期
        /// </summary>
        public string CardValidity { get; set; }

        /// <summary>
        /// 证件照正面
        /// </summary>
        public string IDCardUrlFront { get; set; }

        /// <summary>
        /// 证件照反面
        /// </summary>
        public string IDCardUrlBack { get; set; }

        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }

        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }

        ///// <summary>
        ///// 性别
        ///// 0-女；1-男
        ///// </summary>
        //public int Gender { get; set; }

        /// <summary>
        /// 出生日期
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 手机号
        /// </summary>
        public string PhoneNo { get; set; }

        /// <summary>
        /// 创建来源 1小程序 2IOS 3安卓
        /// </summary>
        public int Source { get; set; }
    }
}