﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    public class UserDetail
    {
        public int Id { get; set; }
        /// <summary>
        /// 微信open_id
        /// </summary>
        public string OpenId { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 全名
        /// </summary>
        public string NickName { get; set; }
        /// <summary>
        /// 国家
        /// </summary>
        public string Country { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 性别(0=女/1=男)
        /// </summary>
        public int Gender { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string HeadImg { get; set; }
        /// <summary>
        /// 语言(1=中文/2=英文)
        /// </summary>
        public int Language { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        public string Phone { get; set; }
        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 注册来源（1=微信/2=APP患者端/3=互联网医院）
        /// </summary>
        public int RegistrationSource { get; set; }
        /// <summary>
        /// 注册时是否新用户（0=不是/1=是）
        /// </summary>
        public bool IsNew { get; set; }
        /// <summary>
        /// 是否完善信息（0=未完善/1=已完善）
        /// </summary>
        public bool IsReg { get; set; }
        /// <summary>
        /// 出生日期
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 是否删除
        /// </summary>
        public bool IsDeleted { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime UpdateTime { get; set; }
        /// <summary>
        /// 化验报告密码
        /// </summary>
        public string TreatmentPassword { get; set; }
        /// <summary>
        /// 推送KEY类型  1=安卓/2=IOS
        /// </summary>
        public int KeyType { get; set; }
        /// <summary>
        /// 安卓推送KEY
        /// </summary>
        public string AndroidId { get; set; }
        /// <summary>
        /// IOS推送KEY
        /// </summary>
        public string IOSId { get; set; }
        /// <summary>
        /// 手机识别号
        /// </summary>
        public string Identifier { get; set; }
        /// <summary>
        /// APP端口语言
        /// </summary>
        public int? APPLanguage { get; set; }
        /// <summary>
        /// APP端微信open_id
        /// </summary>
        public string APPOpenId { get; set; }
        /// <summary>
        /// 腾讯IM账号ID
        /// </summary>
        public string IMId { get; set; }
        /// <summary>
        /// 是否首次登陆app
        /// </summary>
        public bool IsNewLoginApp { get; set; }
        /// <summary>
        /// 是都阅读过知情同意书
        /// </summary>
        public bool IsReadInformed { get; set; }
        public int userType { get; set; }
        public int totalIntegral { get; set; }
        public int aptCount { get; set; }
        public int aptType { get; set; }
        public string Code { get; set; }
        public string LinKingOpenId { get; set; }
    }

    public class ComplaintModel
    {
        public string UserIMID { get; set; }
        /// <summary>
        /// 医生IMID
        /// </summary>
        public string DocIMID { get; set; }
        /// <summary>
        /// 投诉内容
        /// </summary>
        public string ComplaintContent { get; set; }
    }
}
