﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 
    /// </summary>
    public class SchedulingSlotList
    {
        public List<SchedulingSlot> SchedulingSlots { get; set; }
        public List<SchedulingSlotBylanguage> SchedulingSlotBylanguages { get; set; }

        public SchedulingSlotList(string fromDateStr, string toDateStr, List<DoctorDetail> doctorDetails)
        {
            SchedulingSlots = new List<SchedulingSlot>();
            //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            //起始日期
            var fromDate = Convert.ToDateTime(fromDateStr).ToString("yyyy-MM-dd");
            //结束日期
            var toDate = Convert.ToDateTime(toDateStr).ToString("yyyy-MM-dd");
            //Calendar temp = Calendar.getInstance();
            //temp.setTime(fromDate);
            var temp = Convert.ToDateTime(fromDate);
            //打印2001年10月1日到2001年11月4日的日期
            while (temp <= Convert.ToDateTime(toDateStr))
            {
                SchedulingSlot schedulingSlot = new SchedulingSlot(doctorDetails);
                schedulingSlot.Date = fromDate;
                SchedulingSlots.Add(schedulingSlot);
                //天数加上1
                temp.AddDays(1);
            }
        }
        public SchedulingSlotList(string fromDateStr, string toDateStr, List<DoctorWithHosDeptByLanguage> doctorWithHosDeptByLanguageList, int language)
        {
            SchedulingSlotBylanguages = new List<SchedulingSlotBylanguage>();
            //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

            //起始日期
            var fromDate = Convert.ToDateTime(fromDateStr);
            //结束日期
            var toDate = Convert.ToDateTime(toDateStr);
            //Calendar temp = Calendar.getInstance();
            //temp.setTime(fromDate);
            //var temp = fromDate;
            //打印2001年10月1日到2001年11月4日的日期
            while (fromDate <= toDate)
            {
                SchedulingSlotBylanguage schedulingSlotBylanguage = new SchedulingSlotBylanguage(doctorWithHosDeptByLanguageList);
                schedulingSlotBylanguage.Date = fromDate.ToString("yyyy-MM-dd"); ;
                SchedulingSlotBylanguages.Add(schedulingSlotBylanguage);
                //天数加上1
                fromDate = fromDate.AddDays(1);
            }

        }

    }

    public class SchedulingSlot
    {
        public string Date { get; set; }
        public int HasSlot { get; set; }
        public List<DoctorSlot> DoctorSlotList { get; set; }

        public SchedulingSlot(List<DoctorDetail> doctorDetailList)
        {
            HasSlot = 0;
            DoctorSlotList = new List<DoctorSlot>();

            foreach (var doctorDetail in doctorDetailList)
            {
                DoctorSlotList.Add(new DoctorSlot(doctorDetail));
            }
        }
    }
    public class DoctorSlot
    {
        public DoctorDetail DoctorDetail { get; set; }
        public int HasSlot { get; set; }
        public DoctorSlot(DoctorDetail doctorDetail)
        {
            HasSlot = 0;
            DoctorDetail = doctorDetail;
        }
    }
    public class DoctorDetail
    {
        public Dic_Doctor Doctor { get; set; }
        public string CareProvId { get; set; }
        public List<Dic_Nationality> Nation { get; set; }
        public List<Dic_Hos> Hos { get; set; }
        public List<Dic_Dept> Dept { get; set; }
    }
    public class SchedulingSlotBylanguage
    {
        public string Date { get; set; }
        public int HasSlot { get; set; }
        public List<DoctorSlotByLanguage> DoctorWithHosDeptByLanguages { get; set; }

        public SchedulingSlotBylanguage(List<DoctorWithHosDeptByLanguage> doctorWithHosDeptByLanguageList)
        {
            HasSlot = 0;
            DoctorWithHosDeptByLanguages = new List<DoctorSlotByLanguage>();
            
            foreach (var doctorWithHosDeptByLanguage in doctorWithHosDeptByLanguageList)
            {
                DoctorWithHosDeptByLanguages.Add(new DoctorSlotByLanguage(doctorWithHosDeptByLanguage));
            }
            //DoctorWithHosDeptByLanguages = DoctorSlot;
        }
        //public List<DoctorSlotByLanguage> DoctorWithHosDeptByLanguages { get; set; }

    }

    public class DoctorSlotByLanguage
    {
        public DoctorWithHosDeptByLanguage DoctorWithHosDeptByLanguage { get; set; }
        public int HasSlot { get; set; }
        public DoctorSlotByLanguage()
        {
            HasSlot = 0;
        }
        public DoctorSlotByLanguage(DoctorWithHosDeptByLanguage doctorWithHosDeptByLanguage)
        {
            HasSlot = 0;
            DoctorWithHosDeptByLanguage = doctorWithHosDeptByLanguage;
        }
    }

}
