﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 
    /// </summary>
    public class Scheduling
    {
        public Scheduling()
        {
            SlotDateList = new List<SlotDate>();
        }
        public string HosId { get; set; }
        public string DeptId { get; set; }
        public string ServId { get; set; }
        public string HisDocId { get; set; }
        public List<SlotDate> SlotDateList { get; set; }
    }

    public class SlotDateModel
    {
        public string Date { get; set; }
        public string AptUsrn { get; set; }
        public string DeptId { get; set; }
        public string ServId { get; set; }
    }

    public class VaccSlotDateModel
    {
        public string Date { get; set; }
        public List<string> AptUsrn { get; set; } = new List<string>();
        public string DeptId { get; set; }
        public string ServId { get; set; }
        public string DocId { get; set; }
    }

    public class SlotDate
    {
        public string Date { get; set; }
        public int DateType { get; set; }
        public Resource[] ResourceList { get; set; }
    }

    public class Resource
    {
        public string CareProvID { get; set; }
        public Slot[] SlotList { get; set; }
    }

    public class Slot
    {
        public string Usrn { get; set; }
        public string StartTime { get; set; }
        public string EndTime { get; set; }
        public string RbasId { get; set; }
        public int Section { get; set; }

    }

    public class NewPortalSlotDateForDeptModel
    {
        public NewPortalSlotDateForDeptModel()
        {
            Doctor = new List<SlotDateForDoctor>();
        }
        public int HosId { get; set; }
        public string HosName { get; set; }
        public string Addr { get; set; }
        /// <summary>
        /// 经度
        /// </summary>
        public double Longitude { get; set; }
        /// <summary>
        /// 维度
        /// </summary>
        public double Latitude { get; set; }
        public string Distance { get; set; }
        public int DeptId { get; set; }
        public string DeptName { get; set; }
        public List<SlotDateForDoctor> Doctor { get; set; }
    }
    public class SlotDateForDoctor
    {
        public SlotDateForDoctor()
        {
            Service = new List<SlotDateForService>();
            IsPhoneReservation = true;
        }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string ImgList { get; set; }
        public string DocLanguage { get; set; }
        /// <summary>
        /// 是否电话预约
        /// </summary>
        public bool IsPhoneReservation { get; set; }
        public List<SlotDateForService> Service { get; set; }
    }
    public class SlotDateForService
    {
        public SlotDateForService()
        {
            AptSlotList = new List<NewPortalSlotDateForDept>();
        }
        public int AptProj { get; set; }
        public string ServiceCode { get; set; }
        public string ServName { get; set; }
        public List<NewPortalSlotDateForDept> AptSlotList { get; set; }
    }
    public class NewPortalSlotDateForDept
    {
        public string StartTime { get; set; }
        public string AptUsrn { get; set; }
        public int DateType { get; set; }
    }

    public class GetCPWithSlotsForDateList
    {
        public string Hospital { get; set; }
        public string HospitalCN { get; set; }
        public string Location { get; set; }
        public string LocationCN { get; set; }
        public List<GetCPWithSlotsForDateListItem> SlotDates { get; set; }
    }
    public class GetCPWithSlotsForDateListItem
    {
        public string Date { get; set; }
        public List<GetCPWithSlotsForDateListItemDetail> Resources { get; set; }
    }
    public class GetCPWithSlotsForDateListItemDetail
    {
        public string ResourceID { get; set; }
        public string ResourceDesc { get; set; }
        public string CareProvDesc { get; set; }
        public string CareProvID { get; set; }
        public string EQGroup { get; set; }
        public List<GetCPWithSlotsForDateListItemDetailItem> Slots { get; set; }
    }
    public class GetCPWithSlotsForDateListItemDetailItem
    {
        public string USRN { get; set; }
        public string StartTime { get; set; }
        public string EndTime { get; set; }
        public string RBASId { get; set; }
        public string ServiceID { get; set; }
        public bool IsAfternoonSpecified { get; set; }
    }
    public class NewPortalDeptDetail
    {
        public int Id { get; set; }
        public string DeptImg { get; set; }
        public string DeptName { get; set; }
        public string DeptDesc { get; set; }
    }
}
