﻿using ASHermed.SinoInterface.Tools;

namespace ASHermed.SinoInterface.Api.ContractModel.App.Model
{
    /// <summary>
    /// 家庭成员
    /// </summary>
    public class PatientModel : IContentModel, IDataModel
    {
        /// <summary>
        /// 用户id
        /// </summary>
        public int UserId { get; set; }

        /// <summary>
        /// 患者Id
        /// </summary>
        public int PatId { get; set; }

        /// <summary>
        /// PID
        /// </summary>
        public string PId { get; set; }

        /// <summary>
        /// tc患者主键
        /// </summary>
        public string TcRowId { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 姓名（脱敏后的）
        /// </summary>
        public string NameDesensitized { get; set; }

        /// <summary>
        /// 名
        /// </summary>
        public string FirstName { get; set; }

        /// <summary>
        /// 姓
        /// </summary>
        public string LastName { get; set; }

        /// <summary>
        /// 性别 
        /// </summary>
        public int Gender { get; set; }

        /// <summary>
        /// 出生日期
        /// </summary>
        public string Birthday { get; set; }

        /// <summary>
        /// 年龄
        /// </summary>
        public int Age { get; set; }

        /// <summary>
        /// 手机号
        /// </summary>
        public string PhoneNo { get; set; }

        /// <summary> 
        /// 手机号（脱敏后的）
        /// </summary>
        public string PhoneNoDesensitized { get; set; }

        /// <summary>
        /// 证件号
        /// </summary>
        [DeEncryptAttibute]
        public string CardId { get; set; }

        /// <summary>
        /// 证件类型1身份证2护照3香港4台胞5其他
        /// </summary>
        public int CardType { get; set; }

        /// <summary>
        /// tc MRN
        /// </summary>
        public string Mrn { get; set; }

        /// <summary>
        /// 关系：1-本人；2-父母；3-配偶；4-子女；5-朋友；6-其他
        /// </summary>
        public int Ties { get; set; }

        /// <summary>
        /// 是否已完善信息
        /// </summary>
        public bool IsPerfect { get; set; }

        /// <summary>
        /// 监护人信息是否已完善 
        /// </summary>
        public bool IsPerfectGuardian { get; set; }

        /// <summary>
        /// 授权状态：0未授权，1-授权中，2-授权申请已超时，3-授权成功，4-授权不通过，5授权已失效
        /// </summary>
        public int AuthorizationStatus { get; set; }

        /// <summary>
        /// 授权审批审核详情ID
        /// </summary>
        public string AuthorizationDetailIds { get; set; }

        /// <summary>
        /// 头像显示类型
        /// 1-男；2-女；3-小于14岁
        /// </summary>
        public int HeadImgType { get; set; }

        /// <summary>
        /// 监护人手机号
        /// </summary>
        public string GuardianPhone { get; set; }

        /// <summary>
        /// 监护人姓名
        /// </summary>
        public string Guardian { get; set; }
        /// <summary>
        /// 监护人姓
        /// </summary>
        public string LastGuardian { get; set; }
        /// <summary>
        /// 监护人名
        /// </summary>
        public string FirstGuardian { get; set; }
        /// <summary>
        /// 监护人证件类型
        /// </summary>
        public int DocumentType { get; set; }
        /// <summary>
        /// 监护人证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CertificateNumber { get; set; }

        /// <summary>
        /// 国籍
        /// </summary>
        public string Nationality { get; set; }

        /// <summary>
        /// 国籍id
        /// </summary>
        public int NationalityId { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }

        public string Province { get; set; }
        public int ProvinceId { get; set; }
        public string City { get; set; }
        public int CityId { get; set; }
        public string LocalAddress { get; set; }

        /// <summary>
        /// 紧急联系人
        /// </summary>
        public string EmergencyName { get; set; }

        /// <summary>
        /// 紧急联系号码
        /// </summary>
        public string EmergencyPhone { get; set; }

        /// <summary>
        /// 紧急联系人关系
        /// </summary>
        public int EmergencyRelation { get; set; }

        /// <summary>
        /// 如何了解(pubhowknow主键)
        /// </summary>
        public int HowKnow { get; set; }

        /// <summary>
        /// 随访方式(pubcontactway主键)
        /// </summary>
        public int ContactWay { get; set; }

        /// <summary>
        /// 随访方式的联系值
        /// </summary>
        public string Chat { get; set; } 

        /// <summary>
        /// 支付类型(1自费,2保险)
        /// </summary>
        public int PayType { get; set; }

        /// <summary>
        /// 保险照片
        /// </summary>
        public string InsuranceCardUrl { get; set; }
    }
} 