﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    public class PatWithRelationShip : IDataModel
    {
        public int Id { get; set; }
        /// <summary>
        /// 患者挂号id
        /// </summary>
        public string PatId { get; set; }
        /// <summary>
        /// 患者关联查询号(PID)
        /// </summary>
        public string PatMrn { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 名字
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 性别1男2女
        /// </summary>
        public int? Gender { get; set; }
        /// <summary>
        /// 证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CardId { get; set; }
        /// <summary>
        /// 证件类型1身份证2护照
        /// </summary>
        public int CardType { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string PhoneNo { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string District { get; set; }
        /// <summary>
        /// 
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }
        /// <summary>
        /// 国籍
        /// </summary>
        public string Nationality { get; set; }
        /// <summary>
        /// 是否死亡
        /// </summary>
        public bool IsDead { get; set; }
        /// <summary>
        /// 是否有效
        /// </summary>
        public bool IsActive { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string MrnNo { get; set; }

        /// <summary>
        /// 身份证
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string IdNumber { get; set; }

        public int RelationShip { get; set; }
        public DateTime? RecentAptTime { get; set; }
        public string Guardian { get; set; }
        public string GuardianPhone { get; set; }
        public string LastGuardian { get; set; }
        public string FistGuardian { get; set; }
        public int GuardianCardType { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string GuardianIdNumber { get; set; }
        public int IsDefault { get; set; }
        public int Age { get; set; }
        public bool IsReadSignOff { get; set; }

        /// <summary>
        /// 家庭成员关系：1-本人；2-父母；3-配偶；4-子女；5-朋友；6-其他
        /// </summary>
        public int Ties { get; set; }

        /// <summary>
        /// 头像显示类型
        /// 1-男；2-女；3-小于14岁
        /// </summary>
        public int HeadImgType { get; set; }

        /// <summary>
        /// 授权类型 
        /// </summary>
        public int AuthorizationStatus { get; set; }

        /// <summary>
        /// 授权审批审核详情ID
        /// </summary>
        public string AuthorizationDetailIds { get; set; }

        /// <summary>
        /// 是否已完善信息
        /// </summary>
        public bool IsPerfect { get; set; }

        /// <summary>
        /// 监护人信息是否已完善 
        /// </summary>
        public bool IsPerfectGuardian { get; set; }
    }


    public class PatShip
    {
        public int Id { get; set; }
        /// <summary>
        /// 患者挂号id
        /// </summary>
        public string PatId { get; set; }
        /// <summary>
        /// 患者关联查询号(PID)
        /// </summary>
        public string PatMrn { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// 名字
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 性别1男2女
        /// </summary>
        public int? Gender { get; set; }
        /// <summary>
        /// 证件号
        /// </summary>
        public string CardId { get; set; }
        /// <summary>
        /// 证件类型1身份证2护照
        /// </summary>
        public int CardType { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        public string PhoneNo { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string District { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 国籍
        /// </summary>
        public string Nationality { get; set; }

        public bool IsSelect { get; set; }

        public int RelationShip { get; set; }
    }
}
