﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    public class PatAddModel
    {
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public int Gender { get; set; }
        public string Birthday { get; set; }
        public string PhoneNo { get; set; }
        public int CardType { get; set; }
        public string CardId { get; set; }
        /// <summary>
        /// 监护人姓名
        /// </summary>
        public string Guardian { get; set; }
        /// <summary>
        /// 监护人姓
        /// </summary>
        public string LastGuardian { get; set; }
        /// <summary>
        /// 监护人名
        /// </summary>
        public string FirstGuardian { get; set; }
        /// <summary>
        /// 监护人证件类型
        /// </summary>
        public int DocumentType { get; set; }
        /// <summary>
        /// 监护人证件号
        /// </summary>
        public string CertificateNumber { get; set; }
        public int IsDefault { get; set; }
        public int Language { get; set; }
        /// <summary>
        /// 验证码
        /// </summary>
        public string Code { get; set; }
        public string Email { get; set; }
    }

    public class PatUpdateModel
    {
        public int Id { get; set; }
        public string PhoneNo { get; set; }
        public int CardType { get; set; }
        public string CardId { get; set; }
        /// <summary>
        /// 监护人姓名
        /// </summary>
        public string Guardian { get; set; }
        /// <summary>
        /// 监护人姓
        /// </summary>
        public string LastGuardian { get; set; }
        /// <summary>
        /// 监护人名
        /// </summary>
        public string FirstGuardian { get; set; }
        /// <summary>
        /// 监护人证件类型
        /// </summary>
        public int DocumentType { get; set; }
        /// <summary>
        /// 监护人证件号
        /// </summary>
        public string CertificateNumber { get; set; }

        public int Language { get; set; }
        /// <summary>
        /// 验证码
        /// </summary>
        public string Code { get; set; }
    }

    public class CignaUserInfo
    {
        public int Id { get; set; }
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public string PatName { get; set; }
        public string HeadImg { get; set; }
        public string Birthday { get; set; }
        public int? Sex { get; set; }
        public int Language { get; set; }
        public string Email { get; set; }
    }

    [TableAttibute("Pub_Pat_Info")]
    public class NewPatModel : IContentModel, IDataModel
    {
        /// <summary>
        /// patInfo中主键
        /// </summary>
        [TableAttibute("Id")]
        public int Id { get; set; }
        /// <summary>
        /// TC患者ID
        /// </summary>
        public int RowId { get; set; }
        public string PatMrn { get; set; }

        /// <summary>
        /// tc MRN
        /// </summary>
        public string Mrn { get; set; }

        /// <summary>
        /// 国籍
        /// </summary>
        public int NationalityId { get; set; }

        /// <summary>
        /// 证件有效期
        /// </summary>
        public string CardValidity { get; set; }

        /// <summary>
        /// 证件类型1身份证2护照3香港4澳门5其他
        /// </summary>
        public int CardType { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CardId { get; set; }
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public string PatName { get; set; }
        public int Gender { get; set; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string PhoneNo { get; set; }
        public string Birthday { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }

        /// <summary>
        /// 监护人手机号
        /// </summary>
        public string GuardianPhone { get; set; }

        /// <summary>
        /// 监护人姓名
        /// </summary>
        public string Guardian { get; set; }
        /// <summary>
        /// 监护人姓
        /// </summary>
        public string LastGuardian { get; set; }
        /// <summary>
        /// 监护人名
        /// </summary>
        public string FirstGuardian { get; set; }
        /// <summary>
        /// 监护人证件类型
        /// </summary>
        public int DocumentType { get; set; }
        /// <summary>
        /// 监护人证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CertificateNumber { get; set; }
        /// <summary>
        /// 患者证件照地址正面
        /// </summary>
        [ContentAttibute(2)]
        [TableAttibute("IDCardUrlFront")]
        public string IDCardUrlFront { get; set; }
        /// <summary>
        /// 患者证件照地址背面
        /// </summary>
        [ContentAttibute(2)]
        [TableAttibute("IDCardUrlBack")]
        public string IDCardUrlBack { get; set; }
        public string Province { get; set; }
        public int ProvinceId { get; set; }
        public string City { get; set; }
        public int CityId { get; set; }
        public string LocalAddress { get; set; }
        /// <summary>
        /// 紧急联系人
        /// </summary>
        public string EmergencyName { get; set; }
        /// <summary>
        /// 紧急联系号码
        /// </summary>
        public string EmergencyPhone { get; set; }
        /// <summary>
        /// 紧急联系人关系
        /// </summary>
        public int EmergencyRelation { get; set; }
        /// <summary>
        /// 如何了解(pubhowknow主键)
        /// </summary>
        public int HowKnow { get; set; }
        /// <summary>
        /// 如TC有值 PP无值 不做展示 原样传回
        /// </summary>
        public string HowKnowCode { get; set; }
        /// <summary>
        /// 随访方式(pubcontactway主键)
        /// </summary>
        public int ContactWay { get; set; }
        /// <summary>
        /// 随访方式的联系值
        /// </summary>
        public string Chat { get; set; }
        public int Language { get; set; }

        /// <summary>
        /// 保险卡(可能多张 , 隔开的)
        /// </summary>
        [ContentAttibute(3)]
        [TableAttibute("InsuranceCardUrl")]
        public string InsuranceCardUrl { get; set; }
        /// <summary>
        /// 支付类型(1自费,2保险)
        /// </summary>
        public int PayType { get; set; }

        /// <summary>
        /// 是否完善过信息
        /// </summary>
        public bool IsPerf { get; set; }
        /// <summary>
        /// 体检问卷ID  为0则没有填写
        /// </summary>
        public int PhysicalId { get; set; } = -1;
        /// <summary>
        /// 线下预约的ID
        /// </summary>
        public int OutAptId { get; set; }

        /// <summary>
        /// 关系：1-本人；2-父母；3-配偶；4-子女；5-朋友；6-其他
        /// </summary>
        public int Ties { get; set; }

        /// <summary>
        /// 头像显示类型
        /// 1-男；2-女；3-小于14岁
        /// </summary>
        public int HeadImgType { get; set; }

        /// <summary>
        /// 监护人信息是否已完善
        /// </summary>
        public bool IsPerfectGuardian { get; set; } 
    }

    public class TcPat
    {
        public string PatMrn { get; set; }
        public string PatName { get; set; }
        public int Gender { get; set; }
        public int RowId { get; set; }
        public string Phone { get; set; }
        /// <summary>
        /// 是否完善过信息
        /// </summary>
        public bool IsPerf { get; set; }
        /// <summary>
        /// 体检问卷ID  为0则没有填写
        /// </summary>
        public int PhysicalId { get; set; } = -1;
        /// <summary>
        /// 线下预约主键
        /// </summary>
        public int OutAptId { get; set; }
    }

    public class TcNewPatModel
    {
        public string LastName { get; set; }
        public string FirstName { get; set; }
        public int Gender { get; set; }
        public string PhoneNo { get; set; }
        public string Birthday { get; set; }
        public string Email { get; set; }
        public string CardId { get; set; }
        public string Nationality { get; set; }
        public string City { get; set; }
        public string Address { get; set; }
        /// <summary>
        /// 紧急联系人
        /// </summary>
        public string EmergencyName { get; set; }
        /// <summary>
        /// 紧急联系号码
        /// </summary>
        public string EmergencyPhone { get; set; }
        /// <summary>
        /// 紧急联系人关系
        /// </summary>
        public string EmergencyRelationCode { get; set; }
        /// <summary>
        /// 如何了解
        /// </summary>
        public string HowKnowCode { get; set; }
        /// <summary>
        /// 随访方式
        /// </summary>
        public string ContactWayCode { get; set; }
        /// <summary>
        /// 患者备注
        /// </summary>
        public string Remark { get; set; }
    }
    public class FileRequest
    {
        public int[] ids { get; set; }
    }

    public class PatTcInfo : IDataModel
    {
        public int ID { get; set; }
        public string PAT_MRN { get; set; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string PHONE_NO { get; set; }
        public string BIRTHDAY { get; set; }
        public string LAST_NAME { get; set; }
        public string FIRST_NAME { get; set; }
    }
}
