﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    public class InsuranceModel
    {
        public int? Id { get; set; }
        public int? PatId { get; set; }
        /// <summary>
        /// 就诊人姓名
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 保险卡号
        /// </summary>
        public string InsuranceCard { get; set; }
        /// <summary>
        /// 保险公司
        /// </summary>
        public string InsuranceCompany { get; set; }
        /// <summary>
        /// 保险名称
        /// </summary>
        public string InsuranceName { get; set; }

        /// <summary>
        /// 有效期至
        /// </summary>
        public DateTime? ValidityDate { get; set; }
        /// <summary>
        /// 身份证正面照
        /// </summary>
        public string IdentityFrontUrl { get; set; }
        /// <summary>
        /// 身份证反面照
        /// </summary>
        public string IdentityBackUrl { get; set; }
        /// <summary>
        /// 保险卡正面照
        /// </summary>
        public string InsuranceCardUrl { get; set; }
        /// <summary>
        /// 是否阅读保险理赔单
        /// </summary>
        public bool IsReadInsuInfo { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }


        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime AuditTime { get; set; }

        /// <summary>
        /// 理由
        /// </summary>
        public string Reason { get; set; }
        /// <summary>
        /// 1待审核 2已审核,3已失效,4待更新
        /// </summary>
        public int InsuranceStatus { get; set; }
    }
}
