﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 所有首页信息
    /// </summary>
    public class IndexInfo
    {
        /// <summary>
        /// 首页获取科室信息
        /// </summary>
        public List<DeptModel> DeptList { get; set; }

        /// <summary>
        /// 首页获取今日出诊医生
        /// </summary>
        public List<WorkDoctor> DocList { get; set; }

        /// <summary>
        /// 首页获取待就诊信息
        /// </summary>
        public List<TreatedInfo> TreList { get; set; }
    }

    public class TreatedInfo
    {
        public int Id { get; set; }
        public int DocId { get; set; }
        /// <summary>
        /// 医生
        /// </summary>
        public string DocName { get; set; }
        public string DocImage { get; set; }
        public int DeptId { get; set; }
        /// <summary>
        /// 科室
        /// </summary>
        public string DeptName { get; set; }
        /// <summary>
        /// 就诊时间
        /// </summary>
        public string SeeDoctorTime { get; set; }
        /// <summary>
        /// 就诊人
        /// </summary>
        public string PatName { get; set; }
        public bool IsEnglish { get; set; }
        public string OrderNo { get; set; }
        public int AptType { get; set; }
        public int Status { get; set; }
        public string StatusName { get; set; }
        public  int LinKingAptStatus { get; set; }
    }
}
