﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// TC获取的药品模型
    /// </summary>
    public class GetDrugs
    {
        /// <summary>
        /// 药物唯一编号
        /// </summary>
        public string ARCIMCode { get; set; }
        /// <summary>
        /// 药品名称
        /// </summary>
        public string PHCDFDescription { get; set; }
        /// <summary>
        /// 药物描述
        /// </summary>
        public string ARCIMDesc { get; set; }
        /// <summary>
        /// 厂家名称
        /// </summary>
        public string PHMNFName { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string ARCBGDesc { get; set; }
        /// <summary>
        /// 包装单位
        /// </summary>
        public string PACKDescription { get; set; }
        /// <summary>
        /// 剂型--片
        /// </summary>
        public string PHCFDesc { get; set; }
        /// <summary>
        /// 用药途径--口服
        /// </summary>
        public string ROUTEDesc { get; set; }
        /// <summary>
        /// 用药频次
        /// </summary>
        public string PHCFRDesc { get; set; }
        /// <summary>
        /// 规格型号
        /// </summary>
        public string PHCSDesc { get; set; }
        /// <summary>
        /// 剂量单位
        /// </summary>
        public string CTUOMDesc { get; set; }
        /// <summary>
        /// 单次剂量
        /// </summary>
        public string PHCDFBaseQty { get; set; }
        /// <summary>
        /// 单价
        /// </summary>
        public string ITPPrice { get; set; }

    }

    /// <summary>
    /// 返给联空的药品模型
    /// </summary>
    public class LKDrugs
    {
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
       
        /// <summary>
        /// 联空-医疗机构代码(写死PDY01210931010119D1102)
        /// </summary>
        public string MedicalInstitutionCode { get; set; }
        /// <summary>
        /// 联空-药品代码(药物唯一编码)
        /// </summary>
        public string UniqueCode { get; set; }
        /// <summary>
        /// 联空-药品编码
        /// </summary>
        public string MedicalCode { get; set; }
        /// <summary>
        /// 联空-药品化学名
        /// </summary>
        public string DrugName { get; set; }
        /// <summary>
        /// 联空-中文商品名
        /// </summary>
        public string ProNameCn { get; set; }
        /// <summary>
        /// 联空-药品规格
        /// </summary>
        public string Specification { get; set; }
        /// <summary>
        /// 联空-厂家名称
        /// </summary>
        public string ManufactorName { get; set; }
        /// <summary>
        /// 联空-单位
        /// </summary>
        public string Unit { get; set; }
        /// <summary>
        /// 联空-销售单价
        /// </summary>
        public decimal Price { get; set; }
        /// <summary>
        /// 联空-功能主治
        /// </summary>
        public string Indications { get; set; }
        /// <summary>
        /// 联空-使用标志
        /// </summary>
        public int UseSgin { get; set; }
        /// <summary>
        /// 联空-批准文号
        /// </summary>
        public string ApprovalNo { get; set; }
        /// <summary>
        /// 联空-剂型名称
        /// </summary>
        public string DosageForm { get; set; }
        /// <summary>
        /// 联空-制剂标志(默认0)
        /// </summary>
        public int PreparationSign { get; set; }
        /// <summary>
        /// 联空-基药标识(默认-1)
        /// </summary>
        public int DrugFlag { get; set; }
        /// <summary>
        /// 联空-抗生素标识(默认0)
        /// </summary>
        public int AntibioticFlag { get; set; }
        /// <summary>
        /// 联空-毒麻精放标识(默认0)
        /// </summary>
        public int AnaesthesiaFlag { get; set; }
        /// <summary>
        /// 联空-修改标志
        /// </summary>
        public int ModifyFlag { get; set; }
        /// <summary>
        /// 联空-剂量单位
        /// </summary>
        public string DosageUnit { get; set; }
    }
}
