﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    public class DoctorInfoByLanguage
    {
        public int Id { get; set; }
        public string ListImage { get; set; }
        public string DocName { get; set; }
        public int CareProveId { get; set; }
        public string Initial { get; set; }
        public string NamePinyin { get; set; }
        public int AptType { get; set; }
        public string Desc { get; set; }
        public string Title { get; set; }
        public string Exper { get; set; }
        public string Education { get; set; }
        public bool IsVideoDoc { get; set; }
        public decimal VideoPrice { get; set; }
        public bool IsRevisitDoc { get; set; }
        public decimal RevisitPrice { get; set; }
        public string OnlineDeptName { get; set; }
        public string Language { get; set; }
        public List<Dic_Nationality> Nation { get; set; }
        public List<HosByLanguage> Hos { get; set; }
        public List<HosByCity> HosCity { get; set; }
        public List<DeptByLanguage> Dept { get; set; }

    }
    public class DoctorBelongTo
    {
        public int Apt_Hos_Id { get; set; }
        public int Apt_Dept_Id { get; set; }
    }
    public class DoctorInfo
    {
        public int Id { get; set; }
        public string ListImage { get; set; }
        public string DocName { get; set; }
        public int CareProveId { get; set; }
        public string Initial { get; set; }
        public string NamePinyin { get; set; }
        public int AptType { get; set; }
        public string Desc { get; set; }
        public List<Dic_Nationality> Nation { get; set; }
        public List<HosByLanguage> Hos { get; set; }
        public List<DeptByLanguage> Dept { get; set; }
    }

    public class AllDoctorInfo
    {
        public int Id { get; set; }
        public int DeptId { get; set; }
        public string DeptName { get; set; }
        public decimal Price { get; set; }
        public string ListImage { get; set; }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string DocNameOrher { get; set; }
        public string DocDesc { get; set; }
        public bool IsVideoDoc { get; set; }
        public bool IsRevisitDoc { get; set; }
        public int Sort { get; set; }
    }

    public class VideoDoctor
    {
        public int Id { get; set; }
        public int DeptId { get; set; }
        public string DeptName { get; set; }
        public decimal Price { get; set; }
        public string ListImage { get; set; }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string DocDesc { get; set; }
        public bool IsVideoDoc { get; set; }
        public bool IsRevisitDoc { get; set; }
        public int Sort { get; set; }
    }



    public class RevisitDoctor
    {
        public int Id { get; set; }
        public int DeptId { get; set; }
        public string DeptName { get; set; }
        public decimal Price { get; set; }
        public string ListImage { get; set; }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string DocDesc { get; set; }
        public bool IsVideoDoc { get; set; }
        public bool IsRevisitDoc { get; set; }
        public int Sort { get; set; }
    }

    public class WorkDoctor
    {
        public int DeptId { get; set; }
        public string DeptNames { get; set; }
        public string ListImage { get; set; }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string DocDesc { get; set; }
        public bool IsVideoDoc { get; set; }
        public bool IsRevisitDoc { get; set; }

    }

    public class HosByLanguage
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string Addr { get; set; }
        public string Picture { get; set; }
        public string Mobile { get; set; }
        public double Longitude { get; set; }
        public double Latitude { get; set; }
        public string Distance { get; set; }
        public double DistanceDouble { get; set; }
        public string City { get; set; }
        public int SORT { get; set; }
    }

    public class DeptByLanguage
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string ListImage { get; set; }
        public string Icon { get; set; }
        public string Desc { get; set; }
        public string Packages { get; set; }
        public string NamePinyin { get; set; }
        public string Initial { get; set; }
        public string YName { get; set; }
        public string NameEn { get; set; }
        public string NameCn { get; set; }

    }
    public class MaterialDept
    {
        public int DeptId { get; set; }
        public string NameEn { get; set; }
    }


    public class DocDept
    {
        public int DocId { get; set; }
        public string DocNameCn { get; set; }
        public string DocNameEn { get; set; }
        public string DocImage { get; set; }
        public int DeptId { get; set; }
        public string DeptNameCn { get; set; }
        public string DeptNameEn { get; set; }

    }

    public class HisDeptServ
    {
        public int AptDeptId { get; set; }
        public int HisDeptId { get; set; }
        public int HisServId { get; set; }
    }

    public class InsurDoctor
    {
        public int Id { get; set; }
        public int DeptId { get; set; }
        public string DeptName { get; set; }
        public decimal Price { get; set; }
        public string ListImage { get; set; }
        public int DocId { get; set; }
        public string DocName { get; set; }
        public string DocDesc { get; set; }
        public bool IsVideoDoc { get; set; }
        public bool IsRevisitDoc { get; set; }
        public int Sort { get; set; }
    }

}
