﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App.Model
{
    /// <summary>
    /// 市
    /// </summary>
    public class CityEntity
    {
        /// <summary>
        /// 城市ID
        /// </summary>
        [Required(ErrorMessage = "[城市ID]不能为空")]
        public long ID { get; set; }

        /// <summary>
        /// 城市名称
        /// </summary>
        [Required(ErrorMessage = "[城市名称]不能为空")]
        public string Name { get; set; }

        /// <summary>
        /// 省份ID
        /// </summary>
        [Required(ErrorMessage = "[省份Id]不能为空")]
        [Range(1, long.MaxValue, ErrorMessage = "[省份Id]输入错误！")]
        public long ProvinceId { get; set; }

        /// <summary>
        /// 省份名称
        /// </summary>
        [Required(ErrorMessage = "[所属省份（省份名称）]不能为空")]
        public string ProvinceName { get; set; }

        /// <summary>
        /// 默认构造函数
        /// </summary>
        public CityEntity()
        {

        }
    }
}
