﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    public class BillViewModel
    {
    }
    public class OnlineBillList : Online_Bill, IDataModel
    {
        public string PatName { get; set; }
        public string Pid { get; set; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string Phone { get; set; }
        public string DeptName { get; set; }
        public string DocName { get; set; }
        /// <summary>
        /// 收款
        /// </summary>
        public decimal BillPayPrice { get; set; }
        /// <summary>
        /// 欠款
        /// </summary>
        public decimal BillArrears { get; set; }
        public string Remark { get; set; }
    }

    /// <summary>
    /// 保险账单详情
    /// </summary>
    public class OnlineBillDetail
    {
        public OnlineBillDetail()
        {
            PatInfo = new PatInfoDetail();
            BillInfo = new BillInfoDetail();
            AptInfo = new AptInfoDetail();
            PrescriptionInfo = new PrescriptionDetail();
        }
        public PatInfoDetail PatInfo { get; set; }
        public BillInfoDetail BillInfo { get; set; }
        public AptInfoDetail AptInfo { get; set; }
        public PrescriptionDetail PrescriptionInfo { get; set; }
    }
    public class PatInfoDetail : IDataModel
    {
        public int PatId { get; set; }
        public string PatName { get; set; }
        public int Gender { get; set; }
        public string Pid { get; set; }
        public string BirthDay { get; set; }
        public int Age { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string CardId { get; set; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string Phone { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }
        /// <summary>
        /// 保险卡号
        /// </summary>
        public string InsuranceCard { get; set; }
        /// <summary>
        /// 保险公司
        /// </summary>
        public string InsuranceCompany { get; set; }
        /// <summary>
        /// 保险名称
        /// </summary>
        public string InsuranceName { get; set; }
        public int InsuranceId { get; set; }
    }
    public class BillInfoDetail
    {
        /// <summary>
        /// 账单号
        /// </summary>
        public string BillNo { get; set; }
        /// <summary>
        /// 账单日期
        /// </summary>
        public DateTime BillCreateTime { get; set; }
        /// <summary>
        /// 账单金额
        /// </summary>
        public decimal BillPrice { get; set; }
        /// <summary>
        /// 收款
        /// </summary>
        public decimal BillPayPrice { get; set; }
        /// <summary>
        /// 欠款
        /// </summary>
        public decimal BillArrears { get; set; }
        /// <summary>
        /// 客户渠道  1:Patient 线上  2:Cigna -CMB
        /// </summary>
        public int ChannelCode { get; set; }
        /// <summary>
        /// 客户支付金额方式  1:Patient Pay All 2:Cigna-CMB 100% Cover  
        /// </summary>
        public int ChannelPayType { get; set; }
        /// <summary>
        /// 账单类型 1:自费账单 2:保险账单 
        /// </summary>
        public int BillType { get; set; }
    }
    public class AptInfoDetail
    {
        public string OrderNo { get; set; }
        public DateTime AptTime { get; set; }
        /// <summary>
        /// 问诊订单日期
        /// </summary>
        public DateTime StartVisitTime { get; set; }
        public decimal PayPrice { get; set; }
        public decimal AptPrice { get; set; }
        public string DeptName { get; set; }
        public string DocName { get; set; }
        public int AptType { get; set; }
        /// <summary>
        /// 患者主诉
        /// </summary>
        public string CheifComplaint { get; set; }
        /// <summary>
        /// 现病史
        /// </summary>
        public string HistoryPresentIllness { get; set; }
        /// <summary>
        /// 既往史
        /// </summary>
        public string PastMedicalHistory { get; set; }
        /// <summary>
        /// 过敏史
        /// </summary>
        public string AllergyHistory { get; set; }
        /// <summary>
        /// 诊断
        /// </summary>
        public string Diagnosis { get; set; }
        /// <summary>
        /// 处理
        /// </summary>
        public string DealWith { get; set; }
        /// <summary>
        /// 建议
        /// </summary>
        public string Suggest { get; set; }
        /// <summary>
        /// Note
        /// </summary>
        public string Note { get; set; }
    }
    public class PrescriptionDetail
    {
        public PrescriptionDetail()
        {
            Prescriptions = new List<PrescriptionInfo>();
        }
        /// <summary>
        /// 处方单号
        /// </summary>
        public string PrescriptionOrderNo { get; set; }
        /// <summary>
        /// 问诊单号
        /// </summary>
        public string OrderNo { get; set; }
        public DateTime CreateTime { get; set; }
        public decimal TotalAmount { get; set; }
        public string DeptName { get; set; }
        public string DocName { get; set; }
        /// <summary>
        /// 审方
        /// </summary>
        public string AdminAuditor { get; set; }
        /// <summary>
        /// 诊断
        /// </summary>
        public string Diagnosis { get; set; }
        public string PrescriptionNo { get; set; }
        public List<PrescriptionInfo> Prescriptions { get; set; }
    }

    public class OutInternetPrescriptionDrugModel : Out_Internet_Prescription_Drug
    {
        /// <summary>
        /// 数量
        /// </summary>
        public string Quantity { get; set; }

        /// <summary>
        /// 用法
        /// </summary>
        public string Usage { get; set; }
    }

    public class PrescriptionInfo : Out_Internet_Prescription_Info
    {
        public List<OutInternetPrescriptionDrugModel> Drug { get; set; }
    }
}
