﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
	/// 小程序线下预约首页背景
	/// </summary>
	public class BackgroundPicModel
    {

        /// <summary>
        /// 背景地址
        /// </summary>
        public string BackgroundPic { get; set; }
        public List<City> Cities { get; set; }
    }

    public class City
    {
        public string CityName { get; set; }
        public string CityNameEn { get; set; }
    }


    public class AppletBtn
    {

        public int Id { get; set; }
        /// <summary>
        /// 按钮图标
        /// </summary>
        public string BtnIcon { get; set; }
        /// <summary>
        /// 按钮文案
        /// </summary>
        public string BtnText { get; set; }

        /// <summary>
        /// 跳转地址(近期任务时用做区分类型1完善信息,2流调问卷,3体检问卷)
        /// </summary>
        public string GoUrl { get; set; }
        /// <summary>
        /// 跳转类型1 h5  2小程序 3 外部小程序
        /// </summary>
        public int GoType { get; set; }
        /// <summary>
        /// 小程序APPid
        /// </summary>
        public string GoAppId { get; set; }
        /// <summary>
        /// 是否热门
        /// </summary>
        public bool IsHot { get; set; }

    }

    public class MissionModel
    {
        /// <summary>
        /// 任务名称
        /// </summary>
        public string MissionName { get; set; }
        /// <summary>
        /// 患者Id
        /// </summary>
        public int PatId { get; set; }
        public string PatMrn { get; set; }
        /// <summary>
        /// 患者名字
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 图标
        /// </summary>
        public string Icon { get; set; }
        /// <summary>
        /// 跳转路径
        /// </summary>
        public string GoUrl { get; set; }
        /// <summary>
        /// 1完善信息 2流调问卷 3体检问卷 
        /// </summary>
        public int MissionType { get; set; }

        public int AptId { get; set; }
        public int QuestId { get; set; }
        public string Type { get; set; }
        public string PatPhone { get; set; }
        public string FromType { get; set; } = "nurseQr";
        public string PatBirthday { get; set; }
        public int Age { get; set; }
        public int Gender { get; set; }
    }

    public class AptDoc
    {

        public int DocId { get; set; }
        /// <summary>
        /// 医生名字
        /// </summary>
        public string DocName { get; set; }
        /// <summary>
        /// 医生照片
        /// </summary>
        public string DocImg { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// 所属科室
        /// </summary>
        public string DeptNames { get; set; }
        /// <summary>
        /// 跳转地址
        /// </summary>
        public string GoUrl { get; set; }

    }

    public class AptPatData
    {
        public int Id { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime AptTime { get; set; }
        /// <summary>
        /// 患者id
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 患者id
        /// </summary>
        public string PatName { get; set; }
        public string PatMrn { get; set; }
        /// <summary>
        /// 服务
        /// </summary>
        public string Service { get; set; }
    }

    public class HosInfo
    {
        public int Id { get; set; }
        /// <summary>
        /// 门诊名
        /// </summary>
        public string HosName { get; set; }
        /// <summary>
        /// 门诊图片
        /// </summary>
        public string HosPic { get; set; }
        /// <summary>
        /// 门诊地址
        /// </summary>
        public string HosAddress { get; set; }
        /// <summary>
        /// 门诊开工时间
        /// </summary>
        public string HosWorkTime { get; set; }
        /// <summary>
        /// 经度
        /// </summary>
        public string HosLongitude { get; set; }
        /// <summary>
        /// 纬度
        /// </summary>
        public string HosLatitude { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int Sort { get; set; }
    }

    public class AptDocInfo
    {
        /// <summary>
        /// 医生名称
        /// </summary>
        public string DocName { get; set; }
        /// <summary>
        /// 医生语言
        /// </summary>
        public string DocLanguage { get; set; }
        /// <summary>
        /// 医生头像
        /// </summary>
        public string DocImg { get; set; }
    }

    public class DocHosDept
    {
        public int APT_HOS_ID { get; set; }
        public int HIS_HOS_ID { get; set; }
        public string HosName { get; set; }
        public string LONGITUDE { get; set; }
        public string LATITUDE { get; set; }
        public int SORT { get; set; }
        public string PICTURE { get; set; }
        public int APT_DEPT_ID { get; set; }
        public int APT_DOCTOR_ID { get; set; }
        public int APT_TYPE { get; set; }
        public int HIS_DEPT_ID { get; set; }
        public string ServName { get; set; }
        public int HIS_SERV_ID { get; set; }
        public int CARE_PROV_ID { get; set; }
        public int AptProj { get; set; }
        public string DeptName { get; set; }

    }

    public class AptDocListInfo
    {
        /// <summary>
        /// 医生名称
        /// </summary>
        public string DocName { get; set; }
        public string DocNameEn { get; set; }
        /// <summary>
        /// 医生头像
        /// </summary>
        public string DocImg { get; set; }
        /// <summary>
        /// 医生ID
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 医生所在科室
        /// </summary>
        public string DeptName { get; set; }
        /// <summary>
        /// 科室ID
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// 所在门诊
        /// </summary>
        public List<string> HosName { get; set; }
        /// <summary>
        /// 排序用的
        /// </summary>
        public string Initial { get; set; }
        /// <summary>
        /// 医生名称拼音
        /// </summary>
        public string NamePinYin { get; set; }
    }
    public class AptDocList
    {
        /// <summary>
        /// 医生名称
        /// </summary>
        public string DocName { get; set; }
        public string DocNameEn { get; set; }
        /// <summary>
        /// 医生头像
        /// </summary>
        public string DocImg { get; set; }
        /// <summary>
        /// 医生ID
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 医生所在科室
        /// </summary>
        public string DeptName { get; set; }
        /// <summary>
        /// 科室ID
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// 所在门诊
        /// </summary>
        public string HosName { get; set; }
        /// <summary>
        /// 排序用的
        /// </summary>
        public string Initial { get; set; }
        /// <summary>
        /// 医生名称拼音
        /// </summary>
        public string NamePinYin { get; set; }
    }

    /// <summary>
    /// 医生获取排班
    /// </summary>
    public class AptDocScheduling
    {
        /// <summary>
        /// 医院列表
        /// </summary>
        public List<AptHos> HosList { get; set; } = new List<AptHos>();
    }
    public class AptHos
    {
        /// <summary>
        /// 医院名称
        /// </summary>
        public string HosName { get; set; }
        /// <summary>
        /// 诊所图片
        /// </summary>
        public string HosPic { get; set; }
        /// <summary>
        /// PP的门诊ID
        /// </summary>
        public int HosId { get; set; }
        /// <summary>
        /// 距离
        /// </summary>
        public double Distence { get; set; }
        /// <summary>
        /// 科室
        /// </summary>
        public string DeptName { get; set; }
        /// <summary>
        /// PP的科室ID
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// PP的医生ID
        /// </summary>
        public int DocId { get; set; }

        /// <summary>
        /// 是否是客服预约
        /// </summary>
        public bool IsServiceApt { get; set; }
        /// <summary>
        /// 服务排班
        /// </summary>
        public List<ServSlot> ServSlotList { get; set; }
        public bool IsDelete { get; set; }
    }
    public class ServSlot
    {
        /// <summary>
        /// 服务名称
        /// </summary>
        public string ServName { get; set; }
        /// <summary>
        /// PP的服务ID
        /// </summary>
        public int AptProj { get; set; }
        /// <summary>
        /// 日期 yyyy-MM-dd
        /// </summary>
        public string Day { get; set; }
        /// <summary>
        /// 排班
        /// </summary>
        public List<AptSlot> AptSlotList { get; set; }
    }

    public class AptSlot
    {
        /// <summary>
        /// 开始时间
        /// </summary>
        public string StartTime { get; set; }
        /// <summary>
        /// 结束时间
        /// </summary>
        public string EndTime { get; set; }
        /// <summary>
        /// 时间类型 0上午  1下午
        /// </summary>
        public int DateType { get; set; }
        /// <summary>
        /// 排班
        /// </summary>
        public string AptUsrn { get; set; }

    }

    public class AptRecordModel : AptCommitModel
    {
        /// <summary>
        /// 时间类型 0上午  1下午
        /// </summary>
        public int DateType { get; set; }
    }

    public class AptCommitModel
    {
        /// <summary>
        /// 医院ID
        /// </summary>
        public int HosId { get; set; }
        /// <summary>
        /// 科室ID
        /// </summary>
        public int DeptId { get; set; }
        /// <summary>
        /// 医生ID
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 服务ID
        /// </summary>
        public int AptProj { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? AptTime { get; set; }
        /// <summary>
        /// 患者ID
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 患者
        /// </summary>
        public string PatName { get; set; }
        public string PatMrn { get; set; }
        /// <summary>
        /// 排班
        /// </summary>
        public string AptUsrn { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        /// <summary>
        /// 预约来源（1=平台/2=his/4=快速预约（web官网）/8=快速预约（微信官网）/16=快速预约（患者版）/32=中文/64=英文/128=特色门诊预约/256=疫苗预约/512=视频预约）
        /// </summary>
        public int SourceType { get; set; }
        /// <summary>
        /// 渠道1APP、2小程序、3微信、4官网
        /// </summary>
        public int Channel { get; set; }
        /// <summary>
        /// 1中  2英
        /// </summary>
        public int Language { get; set; }
    }

    public class LockUsrnModel
    {
        public string AptUsrn { get; set; }
        /// <summary>
        /// 1中  2英
        /// </summary>
        public int Language { get; set; }
    }

    public class AptDetail
    {
        public int DocId { get; set; }
        public int DeptId { get; set; }
        public int HosId { get; set; }
        public int Id { get; set; }
        /// <summary>
        /// 预约时间 yyyy-MM-dd 
        /// </summary>
        public string AptDay { get; set; }
        /// <summary>
        ///  HH:mm:ss(含AM或PM标签)
        /// </summary>
        public string AptTime { get; set; }
        /// <summary>
        /// 星期几
        /// </summary>
        public string WeekDay { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime Apt_Time { get; set; }
        /// <summary>
        /// 患者
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        public string Phone { get; set; }
        /// <summary>
        /// 患者ID
        /// </summary>
        public int PatId { get; set; }
        public string PatMrn { get; set; }
        /// <summary>
        /// 医生
        /// </summary>
        public string DocName { get; set; }
        /// <summary>
        /// 医生头像
        /// </summary>
        public string DocImg { get; set; }
        /// <summary>
        /// 医生科室
        /// </summary>
        public string DocDept { get; set; }
        /// <summary>
        /// 诊所地址
        /// </summary>
        public string HosAddress { get; set; }
        /// <summary>
        /// 诊所电话
        /// </summary>
        public string HosTel { get; set; }
        /// <summary>
        /// 医院纬度
        /// </summary>
        public string HosLat { get; set; }
        public string HosName { get; set; }
        public string HosShortName { get; set; }
        /// <summary>
        /// 医院经度
        /// </summary>
        public string HosLon { get; set; }
        /// <summary>
        /// 停车信息
        /// </summary>
        public string HosParkingInfo { get; set; }
        /// <summary>
        /// 医院停车场纬度
        /// </summary>
        public string HosParkLat { get; set; }
        /// <summary>
        /// 医院停车场经度
        /// </summary>
        public string HosParkLon { get; set; }
        /// <summary>
        /// 是否需要展示流调问卷模块
        /// </summary>
        public bool IsNeedQuest { get; set; }
        /// <summary>
        /// 问卷ID
        /// </summary>
        public int InfoId { get; set; }
        /// <summary>
        /// 是否填写
        /// </summary>
        public bool IsAnswer { get; set; }
        /// <summary>
        /// 答卷是否通过
        /// </summary>
        public bool IsPass { get; set; }
        /// <summary>
        /// 答卷提交时间
        /// </summary>
        public DateTime? QuestTime { get; set; }
        /// <summary>
        /// 用户ID
        /// </summary>
        public int UserId { get; set; }
        /// <summary>
        /// 预约内部状态(1=待确认/2=取消(cancelled X)/4=已确认(booked P)/8=arrived A)/16=arrived not seen S/32=departed D/64=not show   N
        /// </summary>
        public int InnerStatus { get; set; }
        /// <summary>
        /// 显示用这个  1待确认 2取消  4已确认 5已完成
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 0线下预约 1流感疫苗 2健康体检
        /// </summary>
        public int WechatStatus { get; set; }
        /// <summary>
        /// 疫苗品牌
        /// </summary>
        public string VaccineBrand { get; set; }
        /// <summary>
        /// 疫苗名称
        /// </summary>
        public string VaccineName { get; set; }
        /// <summary>
        /// 是否完善信息
        /// </summary>
        public bool IsPerf { get; set; }
        /// <summary>
        /// 体检名称
        /// </summary>
        public string PhysicalName { get; set; }
        /// <summary>
        /// 体检问卷ID  为0则没有填写
        /// </summary>
        public int PhysicalId { get; set; }
        /// <summary>
        /// 预约创建时间
        /// </summary>
        public DateTime AptCreateTime { get; set; }
        /// <summary>
        /// 患者主诉
        /// </summary>
        public string Remark { get; set; }
    }

    public class UserFeedback
    {
        /// <summary>
        /// 反馈内容
        /// </summary>
        public string Content { get; set; }

        /// <summary>
        /// 联系方式 手机号或微信
        /// </summary>
        public string ContactWay { get; set; }
    }

    public class VaccAptModel
    {
        /// <summary>
        /// 疫苗品牌
        /// </summary>
        public string VaccineBrand { get; set; }
        /// <summary>
        /// 疫苗名称
        /// </summary>
        public string VaccineName { get; set; }
    }
}
