﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 所有预约信息
    /// </summary>
    public class AptData : IDataModel
    {
        public int Id { get; set; }
        public int Apt_Type { get; set; }
        /// <summary>
        /// 患者性别 0=女/1=男
        /// </summary>
        public int Pat_Gender { get; set; }
        public string Dept_Name { get; set; }
        public string Doctor_Name { get; set; }
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string Phone_No { get; set; }
        /// <summary>
        /// 预约码， APT_TYPE=1时为疫苗名称
        /// </summary>
        public string Apt_Usrn { get; set; }
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }
        public string Detail_Image { get; set; }
        public string Apply_Phone { get; set; }
        public string Pat_Name { get; set; }
        public string Serv { get; set; }
        /// <summary>
        /// 预约操作状态(0=未录入系统/1=已录入系统/2=取消/4=已确认)
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 科室图片
        /// </summary>
        public string List_Image { get; set; }
        public int Hos_Id { get; set; }
        public string Hos_Name { get; set; }
        public string Remark { get; set; }
        public string Apply_User { get; set; }
        public DateTime? Birthday { get; set; }
        /// <summary>
        /// 预约时间
        /// </summary>
        public DateTime? Apt_Time { get; set; }


    }

    public class AptDataResb
    {
        public string AptMonth { get; set; }
        public List<AptData> AptData { get; set; }
    }

    public class AptInfos : Out_Apt_Info
    {
        public string First_Name { get; set; }
        public string HosNameCn { get; set; }
        public string HosNameEn { get; set; }
        public string DeptNameCn { get; set; }
        public string DeptNameEn { get; set; }
    }


    public class ConfirmAptInfo
    {
        public string PAT_NAME { get; set; }

        public string PHONE_NO { get; set; }
        public int ID { get; set; }
    }

    public class DataApts
    {
        public int DEPT_ID { get; set; }

        public int STATUS { get; set; }
        public int INNER_STATUS { get; set; }

        public DateTime CREATE_TIME { get; set; }
}

    
}
