﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 群表
    /// </summary>
    public class Tencent_Group_Record
    {
        /// <summary>
        /// 主键
        /// </summary>
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 腾讯群ID
        /// </summary>
        public string GroupId { get; set; }
        public int? UserId { get; set; }
     
        /// <summary>
        /// 患者ID(自己的)
        /// </summary>
        public int PatId { get; set; }
        /// <summary>
        /// 医生ID(自己的)
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 医助ID 取的是sysuser表的主键
        /// </summary>
        public int HelperId { get; set; }
        /// <summary>
        /// 是否禁言
        /// </summary>
        public bool IsForbiddenSpeech { get; set; }
        /// <summary>
        /// 状态(1群存在, 2已解散)
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 订单号
        /// </summary>
        public string OrderNo { get; set; }
        /// <summary>
        /// 结束问诊时间
        /// </summary>
        public DateTime? OverTime { get; set; }
        /// <summary>
        /// 是否需要禁言群
        /// </summary>
        public bool IsNeedForbidden { get; set; }
    }
}
