﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 用户表
    /// </summary>
    public class Sys_User
    {
        /// <summary>
        /// 主键
        /// </summary>
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 昵称
        /// </summary>
        public string NickName { get; set; }
        /// <summary>
        /// 帐号
        /// </summary>
        public string Account { get; set; }
        /// <summary>
        /// 密码
        /// </summary>
        public string Password { get; set; }
        /// <summary>
        /// 用户权限ID
        /// </summary>
        public int RoleId { get; set; }
        /// <summary>
        /// 权限名称
        /// </summary>
        public string RoleName { get; set; }
        /// <summary>
        /// 性别1男2女
        /// </summary>
        public int Sex { get; set; }
        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 手机
        /// </summary>
        public string Phone { get; set; }
        /// <summary>
        /// 微信的OPid
        /// </summary>
        public string OpenId { get; set; }
        /// <summary>
        /// LinKing OpenId
        /// </summary>
        public string LinKingOpenId { get; set; }
        /// <summary>
        /// 后台帐号对应的医生ID
        /// </summary>
        public int DocId { get; set; }
        /// <summary>
        /// 最近登录时间
        /// </summary>
        public DateTime? LastLoginTime { get; set; }
        /// <summary>
        /// 状态1在用0停用
        /// </summary>
        public int Status { get; set; }
        public string CreateUser { get; set; }
        public DateTime? CreateTime { get; set; }
        public string UpdateUser { get; set; }
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 腾讯聊天ID
        /// </summary>
        public string ImId { get; set; }
        /// <summary>
        /// 用户头像
        /// </summary>
        public string UserImg { get; set; }
        /// <summary>
        /// 登录平台(可能多个 ,号隔开)：0-医生版APP；1-后台；2-小程序
        /// </summary>
        public string Platform { get; set; }
        /// <summary>
        /// 是否为健康俱乐部活动账号
        /// </summary>
        public bool IsHealthClub { get; set; }
        /// <summary>
        /// 是否删除：0-未删除；1-已删除
        /// </summary>
        public bool IsDelete { get; set; }

    }
}
