﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel
{
    /// <summary>
    /// 补充材料基础实体
    /// </summary>
    public class Sys_Supplementary_Materials
    {
        /// <summary>
        /// 
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 历史其他机构的就诊病历，检查报告等 非必填 上传图片
        /// </summary>
        public string MedicalRecords { get; set; }
        /// <summary>
        /// 近期是否使用药物 0-否 1-是
        /// </summary>
        public int IsMedicine { get; set; }
        /// <summary>
        /// 近期使用的药物名称，如上一个问题选是则显示
        /// </summary>
        public string Medicine { get; set; }
        /// <summary>
        /// 近期使用的药物名称 图片链接
        /// </summary>
        public string MedicineUrl { get; set; }
        /// <summary>
        /// 体温 ℃
        /// </summary>
        public string Temperature { get; set; }
        /// <summary>
        /// 心跳 次/分
        /// </summary>
        public string Heartbeat { get; set; }
        /// <summary>
        /// 呼吸频率 次/分
        /// </summary>
        public string RespiratoryRate { get; set; }
        /// <summary>
        /// 氧饱和度
        /// </summary>
        public string OxygenSaturation { get; set; }
        /// <summary>
        /// 血压最大值
        /// </summary>
        public string BloodPressureMax { get; set; }
        /// <summary>
        /// 血压最小值
        /// </summary>
        public string BloodPressureMin { get; set; }
        /// <summary>
        /// 血脂最大值
        /// </summary>
        public string BloodFatMax { get; set; }
        /// <summary>
        /// 血脂最小值
        /// </summary>
        public string BloodFatMin { get; set; }
        /// <summary>
        /// 体重
        /// </summary>
        public string Weight { get; set; }
        /// <summary>
        /// 脉搏
        /// </summary>
        public string Pulse { get; set; }
        /// <summary>
        /// 患者id
        /// </summary>
        public int PatientId { get; set; }
        /// <summary>
        /// 医生id
        /// </summary>
        public int DoctorId { get; set; }
        /// <summary>
        /// 医生名称
        /// </summary>
        public string DoctorName { get; set; }
        /// <summary>
        /// 预约号
        /// </summary>
        public int AptId { get; set; }
        /// <summary>
        /// 科室id
        /// </summary>
        public int DepartmentId { get; set; }
        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateUser { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public string UpdateUser { get; set; }
        /// <summary>
        /// 是否删除
        /// </summary>
        public int IsDeleted { get; set; }
        /// <summary>
        /// 是否有药物过敏史
        /// </summary>
        public bool IsDrugAllergy { get; set; }
        /// <summary>
        /// 过敏药物名称
        /// </summary>
        public string DrugAllergyName { get; set; }
        /// <summary>
        /// 添加赋值
        /// </summary>
        public void Created(string Create_User = null, int Is_Deleted = 0)
        {
            this.Id = 0;
            this.CreateTime = DateTime.Now;
            this.CreateUser = !string.IsNullOrEmpty(Create_User) ? Create_User : "System";
            this.IsDeleted = Is_Deleted;
        }
        /// <summary>
        /// 修改赋值
        /// </summary>
        public void Updated(string Update_User = null)
        {
            this.UpdateTime = DateTime.Now;
            this.UpdateUser = !string.IsNullOrEmpty(Update_User) ? Update_User : "System";
        }
        /// <summary>
        /// 删除
        /// </summary>
        public void Deleted(string Update_User = null)
        {
            this.IsDeleted = 1;
            this.UpdateTime = DateTime.Now;
            this.UpdateUser = !string.IsNullOrEmpty(Update_User) ? Update_User : "System";
        }

    }
}
