﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
	/// 用户信息表
	/// </summary>
	public class Pub_User_Info
    {
        /// <summary>
        /// 
        /// </summary>
        [Column("`Id`", ColumnKey.Primary, true)]
        public int ID { get; set; }
        /// <summary>
        /// 微信open_id
        /// </summary>
        public string Open_ID { get; set; }
        /// <summary>
        /// 姓
        /// </summary>
        public string Last_Name { get; set; }
        /// <summary>
        /// 名
        /// </summary>
        public string First_Name { get; set; }
        /// <summary>
        /// 全名
        /// </summary>
        public string Nick_Name { get; set; }
        /// <summary>
        /// 国家
        /// </summary>
        public string Country { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 性别(0=女/1=男)
        /// </summary>
        public int Gender { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string HeadImg { get; set; }
        /// <summary>
        /// 语言(1=中文/2=英文)
        /// </summary>
        public int Language { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        public string Phone { get; set; }
        /// <summary>
        /// 邮箱
        /// </summary>
        public string Email { get; set; }
        /// <summary>
        /// 注册来源（1=微信/2=APP患者端/3=互联网医院4cigna保险用户/5有赞用户）
        /// </summary>
        public int Registration_Source { get; set; }
        /// <summary>
        /// 注册时是否新用户（0=不是/1=是）
        /// </summary>
        public bool Is_New { get; set; }
        /// <summary>
        /// 是否完善信息（0=未完善/1=已完善）
        /// </summary>
        public bool Is_Reg { get; set; }
        /// <summary>
        /// 出生日期
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 是否删除
        /// </summary>
        public bool Is_Deleted { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime Create_Time { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime Update_Time { get; set; }
        /// <summary>
        /// 化验报告密码
        /// </summary>
        public string Treatment_Password { get; set; }
        /// <summary>
        /// 推送KEY类型  1=安卓/2=IOS
        /// </summary>
        public int Key_Type { get; set; }
        /// <summary>
        /// 安卓推送KEY
        /// </summary>
        public string Android_ID { get; set; }
        /// <summary>
        /// IOS推送KEY
        /// </summary>
        public string IOS_ID { get; set; }
        /// <summary>
        /// 手机识别号
        /// </summary>
        public string Identifier { get; set; }
        /// <summary>
        /// APP端口语言
        /// </summary>
        public int? APP_Language { get; set; }
        /// <summary>
        /// APP端微信open_id
        /// </summary>
        public string APP_Open_ID { get; set; }
        /// <summary>
        /// 腾讯IM账号ID
        /// </summary>
        public string IM_ID { get; set; }
        /// <summary>
        /// 是否首次登陆app
        /// </summary>
        public bool Is_New_Login_App { get; set; }
        /// <summary>
        /// 是都阅读过知情同意书
        /// </summary>
        public bool Is_Read_Informed { get; set; }
        /// <summary>
        /// 保险用户ID
        /// </summary>
        public string U_Id { get; set; }
        /// <summary>
        /// 是否确认保险授权
        /// </summary>
        public bool Is_Insurance_Comform { get; set; }
        /// <summary>
        /// 是否有未读的signoff
        /// </summary>
        public bool IsReadSignOff { get; set; }
        /// <summary>
        /// 用户当前版本号
        /// </summary>
        public string VersionNumber { get; set; }
        /// <summary>
        /// 版本更新时间
        /// </summary>
        public DateTime? VersionUpdateTime { get; set; }
        /// <summary>
        /// 有赞openid
        /// </summary>
        public string YZOpenId { get; set; }

        /// <summary>  
        /// 健康俱乐部观看方式
        /// 0-默认；1-app免费观看；2-h5付费观看
        /// </summary> 
        public int YZWatchMode { get; set; }
    }
}
