﻿using ASHermed.SinoInterface.Tools;
using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
	/// 用户信息表
	/// </summary>
    [TableAttibute("Pub_Pat_Info")]
    public class Pub_Pat_Info : IContentModel, IDataModel
    {
        /// <summary>
        /// 
        /// </summary>
        [Column("`Id`", ColumnKey.Primary, true)]
        [TableAttibute("Id")]
        public int Id { get; set; }
        /// <summary>
        /// 患者挂号id
        /// </summary>
        public string Pat_ID { get; set; }
        /// <summary>
        /// 患者关联查询号(PID)
        /// </summary>
        public string Pat_MRN { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string Last_Name { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string First_Name { get; set; }
        /// <summary>
        /// 名字
        /// </summary>
        public string Pat_Name { get; set; }
        /// <summary>
        /// 生日
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 0=女/1=男
        /// </summary>
        public int? Gender { get; set; }
        /// <summary>
        /// 证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Card_ID { get; set; }
        /// <summary>
        /// 证件类型1身份证2护照3香港4澳门5其他
        /// </summary>
        public int Card_Type { get; set; }

        /// <summary>
        /// 证件有效期
        /// </summary>
        public string CardValidity { get; set; }

        public string Clinic_Card { get; set; }
        public string Clinic_CardType { get; set; }
        /// <summary>
        /// 电话
        /// </summary>
        //[EncryptyAttibute]
        //[DeEncryptAttibute]
        public string Phone_NO { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 区
        /// </summary>
        public string District { get; set; }
        /// <summary>
        /// 
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Email { get; set; }
        /// <summary>
        /// 国籍
        /// </summary>
        public string Nationality { get; set; }
        /// <summary>
        /// 是否死亡
        /// </summary>
        public bool Is_Dead { get; set; }
        /// <summary>
        /// 是否有效
        /// </summary>
        public bool Is_Active { get; set; }
        /// <summary>
        /// 患者来源（0=平台/1=his/2=快速预约/3=疫苗预约/4新患者录入）
        /// </summary>
        public int Pat_Source { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public bool Is_Deleted { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string Mrn_NO { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string Pat_Mrn_Number { get; set; }
        /// <summary>
        /// 身份证
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Id_Number { get; set; }
        /// <summary>
        /// 监护人姓名
        /// </summary>
        public string Guardian { get; set; }

        /// <summary>
        /// 监护人 _ 姓
        /// </summary>
        public string Last_Guardian { get; set; }
        /// <summary>
        /// 监护人 _ 名
        /// </summary>
        public string First_Guardian { get; set; }

        /// <summary>
        /// 监护人手机号
        /// </summary>
        public string GuardianPhone { get; set; }

        /// <summary>
        /// 监护人证件类型
        /// </summary>
        public int Document_Type { get; set; }
        /// <summary>
        /// 监护人证件号
        /// </summary>
        [EncryptyAttibute]
        [DeEncryptAttibute]
        public string Certificate_Number { get; set; }
        /// <summary>
        /// signoff最后发送时间
        /// </summary>
        public DateTime? Last_Sign_Off { get; set; }
        /// <summary>
        /// SignOff的报告
        /// </summary>
        public string Last_Sign_EpisodeNo { get; set; }
        public string LinKingOpenId { get; set; }
        /// <summary>
        /// 是否默认 就诊人?地址?
        /// </summary>
        public int IsDefault { get; set; }
        /// <summary>
        /// 是否在TC就诊过儿科
        /// </summary>
        public bool Is_Pediatrics_User { get; set; }
        /// <summary>
        /// 患者备注
        /// </summary>
        public string Pat_Remark { get; set; }
        /// <summary>
        /// 患者身份证照片
        /// </summary>
        [ContentAttibute(2)]
        [TableAttibute("IDCardUrlFront")]
        public string IDCardUrlFront { get; set; }
        [ContentAttibute(2)]
        [TableAttibute("IDCardUrlBack")]
        public string IDCardUrlBack { get; set; }
        /// <summary>
        /// 所在城市id
        /// </summary>
        public int CityId { get; set; }
        /// <summary>
        /// 所在地
        /// </summary>
        public string LocalAddress { get; set; }
        /// <summary>
        /// 紧急联系人
        /// </summary>
        public string EmergencyName { get; set; }
        /// <summary>
        /// 紧急联系号码
        /// </summary>
        public string EmergencyPhone { get; set; }
        /// <summary>
        /// 紧急联系人关系
        /// </summary>
        public string EmergencyRelation { get; set; }
        /// <summary>
        /// 如何了解(pubhowknow主键)
        /// </summary>
        public int HowKnow { get; set; }
        /// <summary>
        /// 随访方式(pubcontactway主键)
        /// </summary>
        public int ContactWay { get; set; }
        /// <summary>
        /// 随访方式的值
        /// </summary>
        public string ContactValue { get; set; }
        /// <summary>
        /// 保险卡(可能多张 , 隔开的)
        /// </summary>
        [ContentAttibute(3)]
        [TableAttibute("InsuranceCardUrl")]
        public string InsuranceCardUrl { get; set; }
        /// <summary>
        /// 支付类型(1自费,2保险)
        /// </summary>
        public int PayType { get; set; }
        /// <summary>
        /// 新老患者标识
        /// </summary>
        public string Mrn { get; set; }
        /// <summary>
        /// 是否有未读的signoff
        /// </summary>
        public bool IsReadSignOff { get; set; }
    }
}
