﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 问答日志
    /// </summary>
    public class Pub_Message_Info
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 用户id
        /// </summary>
        public int? User_Id { get; set; }
        /// <summary>
        /// 患者id
        /// </summary>
        public int Pat_Id { get; set; }
        /// <summary>
        /// 消息来源（0=用户-小影/1=客服-用户/2用户-科室/3科室-用户/4医生/5医助）
        /// </summary>
        public int Source_Type { get; set; }
        /// <summary>
        /// 消息类型（0=文本/1=图片/2=患教）
        /// </summary>
        public int Message_Type { get; set; }
        /// <summary>
        /// 消息内容
        /// </summary>
        public string Content { get; set; }

        public DateTime Create_Time { get; set; }
        /// <summary>
        /// 状态（1=删除/0=未读/2=患者已读/4=后台已读）
        /// </summary>
        public int Status { get; set; }
        /// <summary>
        /// 消息内容类型（1=预约/2=取消预约/4=随访/6=视频咨询/8=其他/16=咨询/32=PP咨询\n/64=小影咨询/128=医助资讯/256=药助咨询/1280=医助-全科/1281=医助-内科\n/1282=医助-心理科/1283=医助-皮肤科/1284=医助-儿科）
        /// </summary>
        public int Content_Type { get; set; }
        /// <summary>
        /// 客服id
        /// </summary>
        public string Service_Id { get; set; }
        /// <summary>
        /// 是否打招呼
        /// </summary>
        public bool Is_Hello { get; set; }
        /// <summary>
        /// 用户已读
        /// </summary>
        public bool User_Read { get; set; }
        /// <summary>
        /// 医生已读
        /// </summary>
        public bool Doctor_Read { get; set; }
        /// <summary>
        /// 业务号
        /// </summary>
        public string Business { get; set; }
        /// <summary>
        /// 业务图片
        /// </summary>
        public string Business_Img { get; set; }
        /// <summary>
        /// 业务数据备注
        /// </summary>
        public string Remake { get; set; }

        /// <summary>
        /// 患教类型（1=原创/2=梅奥）
        /// </summary>
        public int Is_Customize { get; set; }

    }
}
