﻿using ASHermed.SinoInterface.Tools;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App.Entity
{
    /// <summary>
    /// 表名
    /// </summary>
    [TableAttibute("Pub_Insurance")]
    public class Pub_Insurance : IContentModel
    {
        /// <summary>
        /// 表Id，在查询后会通过此Id为主键去更新DB表,查询时跟表名一起为必须加的特性，新增时可以不加
        /// </summary>
        [TableAttibute("Id")]
        public int? Id { get; set; }
        public int? PatId { get; set; }
        /// <summary>
        /// 就诊人姓名
        /// </summary>
        public string PatName { get; set; }
        /// <summary>
        /// 保险卡号
        /// </summary>
        public string InsuranceCard { get; set; }
        /// <summary>
        /// 保险公司
        /// </summary>
        public string InsuranceCompany { get; set; }
        /// <summary>
        /// 保险名称
        /// </summary>
        public string InsuranceName { get; set; }
        /// <summary>
        /// 保险状态(1待审核 2已通过,3已失效,4待更新)
        /// </summary>
        public int? InsuranceStatus { get; set; }
        /// <summary>
        /// 保险起始时间
        /// </summary>
        public DateTime? StartDate { get; set; }
        /// <summary>
        /// 有效期至
        /// </summary>
        public DateTime? ValidityDate { get; set; }
        /// <summary>
        /// 身份证正面照
        /// </summary>
        [ContentAttibute(2)]
        [TableAttibute("IdentityFrontUrl")]
        public string IdentityFrontUrl { get; set; }
        /// <summary>
        /// 身份证反面照
        /// </summary>
        [ContentAttibute(2)]
        [TableAttibute("IdentityBackUrl")]
        public string IdentityBackUrl { get; set; }
        /// <summary>
        /// 保险卡正面照
        /// </summary>
        [ContentAttibute(3)]
        [TableAttibute("InsuranceCardUrl")]
        public string InsuranceCardUrl { get; set; }
        /// <summary>
        /// 是否阅读保险理赔单
        /// </summary>
        public bool IsReadInsuInfo { get; set; }
        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }
        public DateTime CreateTime { get; set; }
        public string CreateUser { get; set; }
        public DateTime UpdateTime { get; set; }
        public string UpdateUser { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime AuditTime { get; set; }

        /// <summary>
        /// 理由
        /// </summary>
        public string Reason { get; set; }

    }
}
