﻿using PoJun.Dapper;
using System;
using System.Collections.Generic;
using System.Text;

namespace ASHermed.SinoInterface.Api.ContractModel.App
{
    /// <summary>
    /// 医生用户表
    /// </summary>
    public class Pub_Doctor_User_Info
    {
        [Column("`Id`", ColumnKey.Primary, true)]
        public int Id { get; set; }
        /// <summary>
        /// 用户名
        /// </summary>
        public string Account { get; set; }
        public string Nick_Name { get; set; }
        /// <summary>
        /// 国家
        /// </summary>
        public string Country { get; set; }
        /// <summary>
        /// 省
        /// </summary>
        public string Province { get; set; }
        /// <summary>
        /// 市
        /// </summary>
        public string City { get; set; }
        /// <summary>
        /// 性别(0=女/1=男)
        /// </summary>
        public string Gender { get; set; }
        /// <summary>
        /// 头像
        /// </summary>
        public string HeadImg { get; set; }
        /// <summary>
        /// 语言(1=中文/2=英文)
        /// </summary>
        public int Language { get; set; }
        public string Phone { get; set; }
        public string Email { get; set; }
        /// <summary>
        /// 出生日期
        /// </summary>
        public string Birthday { get; set; }
        /// <summary>
        /// 角色  1=医生  2=科室助手
        /// </summary>
        public int Role { get; set; }
        /// <summary>
        /// 门诊ID
        /// </summary>
        public int Hos_ID { get; set; }
        /// <summary>
        /// 科室ID
        /// </summary>
        public int Dept_ID { get; set; }
        /// <summary>
        /// 医生ID
        /// </summary>
        public int Doc_ID { get; set; }
        /// <summary>
        /// 状态（0=删除/1=启用/2=禁用）
        /// </summary>
        public int Status { get; set; }
        public DateTime? Create_Time { get; set; }
        public DateTime? Update_Time { get; set; }
        /// <summary>
        /// 手机识别号
        /// </summary>
        public string Identifier { get; set; }
        /// <summary>
        /// 腾讯IM账号ID
        /// </summary>
        public string IM_ID { get; set; }
        /// <summary>
        /// 是否为健康俱乐部活动账号
        /// </summary>
        public string Is_Health_Club { get; set; }
    }
}
